/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.mac;

import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.tokens.mac.HmacAlgorithm;
import org.apache.cxf.rs.security.oauth2.tokens.mac.HmacUtils;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class MacAccessToken
extends ServerAccessToken {
    public MacAccessToken(Client client, String macAuthAlgo, long lifetime) {
        this(client, HmacAlgorithm.toHmacAlgorithm(macAuthAlgo), lifetime);
    }

    public MacAccessToken(Client client, HmacAlgorithm macAlgo, long lifetime) {
        this(client, macAlgo, OAuthUtils.generateRandomTokenKey(), lifetime, System.currentTimeMillis() / 1000L);
    }

    public MacAccessToken(Client client, HmacAlgorithm algo, String tokenKey, long lifetime, long issuedAt) {
        super(client, "mac", tokenKey, lifetime, issuedAt);
        this.setExtraParameters(algo);
    }

    private void setExtraParameters(HmacAlgorithm algo) {
        super.getParameters().put("secret", HmacUtils.generateSecret(algo));
        super.getParameters().put("algorithm", algo.getOAuthName());
    }

    public String getMacKey() {
        return super.getTokenKey();
    }

    public String getMacSecret() {
        return super.getParameters().get("secret");
    }

    public String getMacAlgorithm() {
        return super.getParameters().get("algorithm");
    }
}

