/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Binding;
import fit.ColumnFixture;
import fit.Fixture;
import fit.Parse;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import junit.framework.TestCase;

public class ColumnFixtureTest
extends TestCase {
    private TestFixture fixture;

    protected void setUp() throws Exception {
        this.fixture = new TestFixture();
    }

    public void testBindColumnToMethod() throws Exception {
        String[] methodSpecifiers = new String[]{"method()", "method?", "method!", "string method()", "string method?", "string method!"};
        String[] resultingMethodName = new String[]{"method", "method", "method", "stringMethod", "stringMethod", "stringMethod"};
        for (int i = 0; i < methodSpecifiers.length; ++i) {
            Parse table = new Parse("<table><tr><td>" + methodSpecifiers[i] + "</td></tr></table>");
            Parse tableHead = table.parts.parts;
            this.fixture.bind(tableHead);
            ColumnFixtureTest.assertNotNull((String)(methodSpecifiers[i] + " no binding found."), (Object)this.fixture.columnBindings[0]);
            Method method = this.fixture.columnBindings[0].adapter.method;
            ColumnFixtureTest.assertNotNull((String)(methodSpecifiers[i] + "no method found."), (Object)method);
            ColumnFixtureTest.assertEquals((String)resultingMethodName[i], (String)method.getName());
        }
    }

    public void testBindColumnToField() throws Exception {
        Parse table = new Parse("<table><tr><td>field</td></tr></table>");
        Parse tableHead = table.parts.parts;
        this.fixture.bind(tableHead);
        ColumnFixtureTest.assertNotNull((Object)this.fixture.columnBindings[0]);
        Field field = this.fixture.columnBindings[0].adapter.field;
        ColumnFixtureTest.assertNotNull((Object)field);
        ColumnFixtureTest.assertEquals((String)"field", (String)field.getName());
    }

    public void testGracefulColumnNames() throws Exception {
        Parse table = new Parse("<table><tr><td>string field</td></tr></table>");
        Parse tableHead = table.parts.parts;
        this.fixture.bind(tableHead);
        ColumnFixtureTest.assertNotNull((Object)this.fixture.columnBindings[0]);
        Field field = this.fixture.columnBindings[0].adapter.field;
        ColumnFixtureTest.assertNotNull((Object)field);
        ColumnFixtureTest.assertEquals((String)"stringField", (String)field.getName());
    }

    public void testBindColumnToFieldSymbol() throws Exception {
        Fixture.setSymbol("Symbol", "42");
        Parse table = new Parse("<table><tr><td>field=</td></tr><tr><td>Symbol</td></tr></table>");
        Parse rows = table.parts;
        this.fixture.doRows(rows);
        Binding binding = this.fixture.columnBindings[0];
        ColumnFixtureTest.assertNotNull((Object)binding);
        ColumnFixtureTest.assertEquals(Binding.RecallBinding.class, binding.getClass());
        Field field = binding.adapter.field;
        ColumnFixtureTest.assertNotNull((Object)field);
        ColumnFixtureTest.assertEquals((String)"field", (String)field.getName());
        ColumnFixtureTest.assertEquals((int)42, (int)this.fixture.field);
    }

    public void testBindColumnToMethodSymbol() throws Exception {
        Parse table = new Parse("<table><tr><td>=method?</td></tr><tr><td>MethodSymbol</td></tr></table>");
        Parse rows = table.parts;
        this.fixture.doRows(rows);
        Binding binding = this.fixture.columnBindings[0];
        ColumnFixtureTest.assertNotNull((Object)binding);
        ColumnFixtureTest.assertEquals(Binding.SaveBinding.class, binding.getClass());
        Method method = binding.adapter.method;
        ColumnFixtureTest.assertEquals((String)"method", (String)method.getName());
        ColumnFixtureTest.assertEquals((Object)"86", (Object)Fixture.getSymbol("MethodSymbol"));
    }

    static class TestFixture
    extends ColumnFixture {
        public int field;
        public String stringField;

        TestFixture() {
        }

        public int method() {
            return 86;
        }

        public String stringMethod() {
            return null;
        }
    }
}

