/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.FitMatcher;
import junit.framework.TestCase;

public class FitMatcherTest
extends TestCase {
    private void assertMatch(String expression, Number parameter) throws Exception {
        FitMatcher matcher = new FitMatcher(expression, parameter);
        FitMatcherTest.assertTrue((boolean)matcher.matches());
    }

    private void assertNoMatch(String expression, Number parameter) throws Exception {
        FitMatcher matcher = new FitMatcher(expression, parameter);
        FitMatcherTest.assertFalse((boolean)matcher.matches());
    }

    private void assertException(String expression, Object parameter) {
        FitMatcher matcher = new FitMatcher(expression, parameter);
        try {
            matcher.matches();
            FitMatcherTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testSimpleMatches() throws Exception {
        this.assertMatch("_<3", new Integer(2));
        this.assertNoMatch("_<3", new Integer(3));
        this.assertMatch("_<4", new Integer(3));
        this.assertMatch("_ < 9", new Integer(4));
        this.assertMatch("<3", new Integer(2));
        this.assertMatch(">4", new Integer(5));
        this.assertMatch(">-3", new Integer(-2));
        this.assertMatch("<3.2", new Double(3.1));
        this.assertNoMatch("<3.2", new Double(3.3));
        this.assertMatch("<=3", new Double(3.0));
        this.assertMatch("<=3", new Double(2.0));
        this.assertNoMatch("<=3", new Double(4.0));
        this.assertMatch(">=2", new Double(2.0));
        this.assertMatch(">=2", new Double(3.0));
        this.assertNoMatch(">=2", new Double(1.0));
    }

    public void testExceptions() throws Exception {
        this.assertException("X", new Integer(1));
        this.assertException("<32", "xxx");
    }

    public void testMessage() throws Exception {
        FitMatcher matcher = new FitMatcher("_>25", new Integer(3));
        FitMatcherTest.assertEquals((String)"<b>3</b>>25", (String)matcher.message());
        matcher = new FitMatcher(" < 32", new Integer(5));
        FitMatcherTest.assertEquals((String)"<b>5</b> < 32", (String)matcher.message());
    }

    public void testTrichotomy() throws Exception {
        this.assertMatch("5<_<32", new Integer(8));
        this.assertNoMatch("5<_<32", new Integer(5));
        this.assertNoMatch("5<_<32", new Integer(32));
        this.assertMatch("10>_>5", new Integer(6));
        this.assertNoMatch("10>_>5", new Integer(10));
        this.assertNoMatch("10>_>5", new Integer(5));
        this.assertMatch("10>=_>=5", new Integer(10));
        this.assertMatch("10>=_>=5", new Integer(5));
    }
}

