/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.FitProtocol;
import fit.Parse;
import fit.exception.FitParseException;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.runResults.TestResults;
import fitlibrary.runResults.TestResultsOnCounts;
import fitlibrary.suite.ReportListener;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.Socket;
import org.apache.log4j.Logger;
import util.StreamReader;

public abstract class FitServerBridge {
    static Logger logger = FitLibraryLogger.getLogger(FitServerBridge.class);
    protected ReportListener reportListener = new TableReportListener();
    protected TestResults suiteTestResults = new TestResultsOnCounts();
    protected OutputStream socketOutput;
    protected StreamReader socketReader;
    private boolean verbose = false;
    private String host;
    private int port;
    private int socketToken;
    private Socket socket;
    protected boolean exit = true;
    public static String FITNESSE_URL = "";

    public boolean isExit() {
        return this.exit;
    }

    private void setFitNesseUrl(String host, int port) {
        this.host = host;
        this.port = port;
        FITNESSE_URL = "http://" + host + ":" + port + "/";
    }

    public void run(String[] argv) throws Exception {
        this.args(argv);
        this.establishConnection();
        this.validateConnection();
        this.process();
        this.socket.close();
        this.exit();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process() {
        FitServerBridge.logger.trace((Object)"Ready to received pages from FitNesse");
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                FitServerBridge.logger.trace((Object)"Reading page size...");
                size = FitProtocol.readSize(this.socketReader);
                if (size == 0) {
                    FitServerBridge.logger.trace((Object)"No more pages to receive from FitNesse");
                    return;
                }
                FitServerBridge.logger.trace((Object)("Received page of size " + size + " from FitNesse"));
                try {
                    document = FitProtocol.readDocument(this.socketReader, size);
                    storyTestResults = this.doTables(document);
                    FitServerBridge.logger.trace((Object)"Finished running page");
                    this.suiteTestResults.add(storyTestResults);
                }
                catch (FitParseException e) {
                    this.exception(e);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.exception(e);
        }
        ** GOTO lbl-1000
    }

    public abstract TestResults doTables(String var1);

    public String readDocument() throws Exception {
        int size = FitProtocol.readSize(this.socketReader);
        return FitProtocol.readDocument(this.socketReader, size);
    }

    public void args(String[] argv) {
        this.printArgs(argv);
        int i = this.gatherOptions(argv);
        String hostName = argv[i++];
        int portNo = Integer.parseInt(argv[i++]);
        this.setFitNesseUrl(hostName, portNo);
        this.socketToken = Integer.parseInt(argv[i++]);
    }

    private int gatherOptions(String[] argv) {
        int i = 0;
        while (argv[i].startsWith("-")) {
            String arg = argv[i];
            if ("-v".equals(arg)) {
                this.verbose = true;
            } else if ("-x".equals(arg)) {
                this.exit = false;
            } else {
                this.usage();
            }
            ++i;
        }
        return i;
    }

    private void printArgs(String[] argv) {
        logger.trace((Object)("Arguments: " + FitServerBridge.mkString(argv, " ")));
    }

    public static String mkString(Object[] array, String separator) {
        StringBuilder s = new StringBuilder();
        boolean first = true;
        for (Object a : array) {
            if (first) {
                first = false;
            } else {
                s.append(separator);
            }
            s.append(a.toString());
        }
        return s.toString();
    }

    protected void usage() {
        System.out.println("usage: java fit.FitServer [-v] host port socketTicket");
        System.out.println("\t-v\tverbose");
        System.exit(-1);
    }

    protected void exception(Exception e) {
        this.printExceptionDetails(e);
        Table table = TableFactory.table(TableFactory.row("Exception occurred: "));
        ((Cell)((Row)table.at(0)).at(0)).error(this.suiteTestResults, e);
        this.reportListener.tableFinished(table);
        this.reportListener.tablesFinished(this.suiteTestResults);
    }

    public void printExceptionDetails(Exception e) {
        logger.trace((Object)("Exception: " + e.getMessage()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(out));
        logger.trace((Object)(out.toString() + "\n"));
    }

    public void exit() throws Exception {
        logger.trace((Object)("End results: " + this.suiteTestResults.getCounts().toString()));
    }

    public int exitCode() {
        return this.suiteTestResults.getCounts().wrong + this.suiteTestResults.getCounts().exceptions;
    }

    public void establishConnection() throws Exception {
        this.establishConnection(this.makeHttpRequest());
    }

    public void establishConnection(String httpRequest) throws Exception {
        logger.trace((Object)("Connecting to FitNesse on " + this.host + " : " + this.port));
        this.socket = new Socket(this.host, this.port);
        logger.trace((Object)"Socket is connected");
        this.socketOutput = this.socket.getOutputStream();
        this.socketReader = new StreamReader(this.socket.getInputStream());
        byte[] bytes = httpRequest.getBytes("UTF-8");
        this.socketOutput.write(bytes);
        this.socketOutput.flush();
        logger.trace((Object)"Http request sent to FitNesse");
    }

    private String makeHttpRequest() {
        return "GET /?responder=socketCatcher&ticket=" + this.socketToken + " HTTP/1.1\r\n\r\n";
    }

    public void validateConnection() throws Exception {
        int statusSize = FitProtocol.readSize(this.socketReader);
        if (statusSize == 0) {
            logger.trace((Object)"Connection to FitNesse is ok");
        } else {
            String errorMessage = FitProtocol.readDocument(this.socketReader, statusSize);
            logger.trace((Object)("Connection to FitNesse failed because: " + errorMessage + "\n"));
            System.out.println("An error occured while connecting to FitNesse.");
            System.out.println(errorMessage);
            System.exit(-1);
        }
    }

    public static byte[] readTable(Parse table) throws Exception {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)byteBuffer, "UTF-8");
        PrintWriter writer = new PrintWriter(streamWriter);
        Parse more = table.more;
        table.more = null;
        if (table.trailer == null) {
            table.trailer = "";
        }
        table.print(writer);
        table.more = more;
        writer.close();
        return byteBuffer.toByteArray();
    }

    public static byte[] readTable(Table table) throws Exception {
        StringBuilder builder = new StringBuilder();
        table.toHtml(builder);
        return builder.toString().getBytes("UTF-8");
    }

    public void sendTableReport(Table table) {
        logger.trace((Object)"Sending table report to FitNesse");
        try {
            byte[] bytes = FitServerBridge.readTable(table);
            if (bytes.length > 0) {
                FitProtocol.writeData(bytes, this.socketOutput);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendTestResults(TestResults testResults) {
        logger.trace((Object)("Sending results to FitNesse: " + testResults));
        try {
            FitProtocol.writeCounts(testResults.getCounts(), this.socketOutput);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setFitNesseUrl(String url) {
        FITNESSE_URL = url;
    }

    class TableReportListener
    implements ReportListener {
        TableReportListener() {
        }

        @Override
        public void tableFinished(Table table) {
            FitServerBridge.this.sendTableReport(table);
        }

        @Override
        public void tablesFinished(TestResults testResults) {
            FitServerBridge.this.sendTestResults(testResults);
        }
    }
}

