/*
 * Decompiled with CFR 0.152.
 */
package fit.eg.bowling;

public class BowlingScorer {
    private int[] rolls = new int[21];
    protected int rollNumber = 0;

    public void roll(int pins) {
        this.rolls[this.rollNumber++] = pins;
    }

    public int score(int frame) {
        int score = 0;
        int roll = 0;
        for (int f = 0; f < frame; ++f) {
            if (this.strike(roll)) {
                score += 10 + this.nextTwoBallsForStrike(roll);
                ++roll;
                continue;
            }
            if (this.spare(roll)) {
                score += 10 + this.nextBallForSpare(roll);
                roll += 2;
                continue;
            }
            score += this.ballsInFrame(roll);
            roll += 2;
        }
        return score;
    }

    private int ballsInFrame(int roll) {
        return this.rolls[roll] + this.rolls[roll + 1];
    }

    private int nextBallForSpare(int roll) {
        return this.rolls[roll + 2];
    }

    private int nextTwoBallsForStrike(int roll) {
        return this.rolls[roll + 1] + this.rolls[roll + 2];
    }

    private boolean spare(int roll) {
        return this.rolls[roll] + this.rolls[roll + 1] == 10;
    }

    private boolean strike(int roll) {
        return this.rolls[roll] == 10;
    }

    protected boolean lastRollWasStrike() {
        return this.rolls[this.rollNumber - 1] == 10;
    }

    protected boolean lastRollWasSpare() {
        return this.rolls[this.rollNumber - 2] + this.rolls[this.rollNumber - 1] == 10;
    }
}

