/*
 * Decompiled with CFR 0.152.
 */
package fitbook;

import fit.Fixture;
import fitbook.UserCopy;
import fitbook.UserFixture;
import fitbook.chat.ChatRoom;
import fitbook.chat.User;
import fitlibrary.DoFixture;
import fitlibrary.ParamRowFixture;
import java.util.Set;

public class ChatStart
extends DoFixture {
    private ChatRoom chat = new ChatRoom();

    public ChatStart() {
        this.setSystemUnderTest(this.chat);
    }

    public boolean connectUser(String userName) {
        return this.chat.connectUser(userName);
    }

    public boolean userCreatesRoom(String userName, String roomName) {
        return this.chat.userCreatesRoom(userName, roomName);
    }

    public boolean userEntersRoom(String userName, String roomName) {
        return this.chat.userEntersRoom(userName, roomName);
    }

    public Fixture usersInRoom(String roomName) {
        Set<User> users = this.chat.usersInRoom(roomName);
        Object[] collection = new Object[users.size()];
        int i = 0;
        for (User user : users) {
            collection[i++] = new UserCopy(user.getName());
        }
        return new ParamRowFixture(collection, UserCopy.class);
    }

    public boolean disconnectUser(String userName) {
        return this.chat.disconnectUser(userName);
    }

    public int occupantCount(String roomName) {
        return this.chat.occupants(roomName);
    }

    public Fixture usersInRoom2(String roomName) {
        return new ParamRowFixture(this.chat.usersInRoom(roomName).toArray(), User.class);
    }

    public UserFixture connect(String userName) {
        if (this.chat.connectUser(userName)) {
            return new UserFixture(this.chat, this.chat.user(userName));
        }
        throw new RuntimeException("Duplicate user");
    }

    public DoFixture room(String roomName) {
        return new DoFixture(this.chat.room(roomName));
    }

    public boolean roomIsEmpty(String roomName) {
        return this.chat.occupants(roomName) == 0;
    }
}

