/*
 * Decompiled with CFR 0.152.
 */
package fitbook.chat;

import fitbook.chat.Room;
import fitbook.chat.User;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ChatRoom {
    private Map<String, User> users = new HashMap<String, User>();
    private Map<String, Room> rooms = new HashMap<String, Room>();

    public boolean connectUser(String userName) {
        if (this.user(userName) != null) {
            return false;
        }
        this.users.put(userName, new User(userName));
        return true;
    }

    public boolean disconnectUser(String userName) {
        User user = this.users.remove(userName);
        if (user == null) {
            return false;
        }
        for (Room room : this.rooms.values()) {
            room.remove(user);
        }
        return true;
    }

    public boolean userCreatesRoom(String userName, String roomName) {
        User user = this.user(userName);
        if (user == null) {
            throw new RuntimeException("Unknown user name: " + userName);
        }
        this.createRoom(roomName, user);
        return true;
    }

    public void createRoom(String roomName, User user) {
        if (this.rooms.containsKey(roomName)) {
            throw new RuntimeException("Duplicate room name: " + roomName);
        }
        this.rooms.put(roomName, new Room(roomName, user, this));
    }

    public boolean userEntersRoom(String userName, String roomName) {
        User user = this.user(userName);
        Room room = this.room(roomName);
        if (user == null || room == null) {
            return false;
        }
        room.add(user);
        return true;
    }

    public boolean userLeavesRoom(String userName, String roomName) {
        User user = this.user(userName);
        Room room = this.room(roomName);
        if (user == null || room == null) {
            return false;
        }
        return room.remove(user);
    }

    public int occupants(String roomName) {
        Room room = this.room(roomName);
        if (room == null) {
            throw new RuntimeException("Unknown room: " + roomName);
        }
        return room.occupantCount();
    }

    public boolean userPaysDollarFee(String userName, double fee) {
        return true;
    }

    public Iterator<Room> getRooms() {
        return this.rooms.values().iterator();
    }

    public boolean removeRoom(String roomName) {
        Room room = this.room(roomName);
        if (room == null) {
            return false;
        }
        if (room.occupantCount() > 0) {
            return false;
        }
        this.rooms.remove(roomName);
        return true;
    }

    public User user(String userName) {
        return this.users.get(userName);
    }

    public Room room(String roomName) {
        return this.rooms.get(roomName);
    }

    public Iterator<User> usersIn(String roomName) {
        Room room = this.room(roomName);
        if (room == null) {
            throw new RuntimeException("Unknown room");
        }
        return room.users();
    }

    public Set<User> usersInRoom(String roomName) {
        Room room = this.room(roomName);
        if (room == null) {
            throw new RuntimeException("Unknown room");
        }
        return room.usersIn();
    }

    public void renameRoom(Room room, String name) {
        this.rooms.remove(room.getName());
        this.rooms.put(name, room);
    }
}

