/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.batch;

import fit.Counts;
import fitlibrary.batch.testRun.FitLibraryBatching;
import fitlibrary.batch.testRun.FitLibraryTestEngine;
import fitlibrary.batch.trinidad.InMemoryTestImpl;
import fitlibrary.batch.trinidad.SingleTestResult;
import fitlibrary.batch.trinidad.TestResult;
import fitlibrary.runResults.TableListener;
import fitlibrary.table.Tables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestFitLibraryTestEngine {
    final Mockery context = new JUnit4Mockery();
    final FitLibraryBatching mockBatching = (FitLibraryBatching)this.context.mock(FitLibraryBatching.class);
    final String linebreak = System.getProperty("line.separator");

    @Test
    public void noTables() {
        String string = "Test One";
        String string2 = "contents";
        FitLibraryTestEngine fitLibraryTestEngine = new FitLibraryTestEngine(this.mockBatching);
        TestResult testResult = fitLibraryTestEngine.runTest(new InMemoryTestImpl(string, string2));
        Assert.assertThat((Object)testResult, this.matchesTestResult(new SingleTestResult(new Counts(), string, " contains no tables", 0L)));
    }

    @Test
    public void passWithNoOutput() {
        String string = "Test Two";
        String string2 = "<table><tr><td>a</td></tr></table>";
        FitLibraryBatching fitLibraryBatching = new FitLibraryBatching(){

            @Override
            public void doTables(Tables tables, TableListener tableListener) {
                tableListener.getTestResults().pass();
            }

            @Override
            public void setCurrentPageName(String string) {
            }
        };
        FitLibraryTestEngine fitLibraryTestEngine = new FitLibraryTestEngine(fitLibraryBatching);
        TestResult testResult = fitLibraryTestEngine.runTest(new InMemoryTestImpl(string, string2));
        Assert.assertThat((Object)testResult, this.matchesTestResult(new SingleTestResult(new Counts(1, 0, 0, 0), string, string2, 0L)));
    }

    @Test
    public void failWithOutOnly() {
        String string = "Test Three";
        String string2 = "<table><tr><td>a</td></tr></table>";
        FitLibraryBatching fitLibraryBatching = new FitLibraryBatching(){

            @Override
            public void doTables(Tables tables, TableListener tableListener) {
                tableListener.getTestResults().fail();
                System.out.print("Mess");
                System.out.println("age");
            }

            @Override
            public void setCurrentPageName(String string) {
            }
        };
        FitLibraryTestEngine fitLibraryTestEngine = new FitLibraryTestEngine(fitLibraryBatching);
        TestResult testResult = fitLibraryTestEngine.runTest(new InMemoryTestImpl(string, string2));
        Assert.assertThat((Object)testResult.getContent(), (Matcher)CoreMatchers.equalTo((Object)(string2 + "\n<hr/><h1>out</h1>\n<pre>\nMessage" + this.linebreak + "\n</pre>\n")));
        Assert.assertThat((Object)testResult, this.matchesTestResult(new SingleTestResult(new Counts(0, 1, 0, 0), string, string2 + "\n<hr/><h1>out</h1>\n<pre>\nMessage" + this.linebreak + "\n</pre>\n", 0L)));
    }

    @Test
    public void exceptionWithErrOnly() {
        String string = "Test Three";
        String string2 = "<table><tr><td>a</td></tr></table>";
        FitLibraryBatching fitLibraryBatching = new FitLibraryBatching(){

            @Override
            public void doTables(Tables tables, TableListener tableListener) {
                tableListener.getTestResults().exception();
                System.err.println("Message");
            }

            @Override
            public void setCurrentPageName(String string) {
            }
        };
        FitLibraryTestEngine fitLibraryTestEngine = new FitLibraryTestEngine(fitLibraryBatching);
        TestResult testResult = fitLibraryTestEngine.runTest(new InMemoryTestImpl(string, string2));
        Assert.assertThat((Object)testResult, this.matchesTestResult(new SingleTestResult(new Counts(0, 0, 0, 1), string, string2 + "\n<hr/><h1>err</h1>\n<pre>\nMessage" + this.linebreak + "\n</pre>\n", 0L)));
    }

    @Test
    public void ignoreWithOutAndErr() {
        String string = "Test Three";
        String string2 = "<table><tr><td>a</td></tr></table>";
        FitLibraryBatching fitLibraryBatching = new FitLibraryBatching(){

            @Override
            public void doTables(Tables tables, TableListener tableListener) {
                tableListener.getTestResults().ignore();
                System.out.println("Out Message");
                System.err.println("Err Message");
            }

            @Override
            public void setCurrentPageName(String string) {
            }
        };
        FitLibraryTestEngine fitLibraryTestEngine = new FitLibraryTestEngine(fitLibraryBatching);
        TestResult testResult = fitLibraryTestEngine.runTest(new InMemoryTestImpl(string, string2));
        Assert.assertThat((Object)testResult, this.matchesTestResult(new SingleTestResult(new Counts(0, 0, 1, 0), string, string2 + "\n<hr/><h1>out</h1>\n<pre>\nOut Message" + this.linebreak + "\n</pre>\n" + "\n<hr/><h1>err</h1>\n<pre>\nErr Message" + this.linebreak + "\n</pre>\n", 0L)));
    }

    @Test
    public void ignoreWithOutAndErrWithBody() {
        String string = "Test Three";
        String string2 = "<body><table><tr><td>a</td></tr></table>";
        FitLibraryBatching fitLibraryBatching = new FitLibraryBatching(){

            @Override
            public void doTables(Tables tables, TableListener tableListener) {
                tableListener.getTestResults().ignore();
                System.out.println("Out Message");
                System.err.println("Err Message");
            }

            @Override
            public void setCurrentPageName(String string) {
            }
        };
        FitLibraryTestEngine fitLibraryTestEngine = new FitLibraryTestEngine(fitLibraryBatching);
        TestResult testResult = fitLibraryTestEngine.runTest(new InMemoryTestImpl(string, string2 + "</body>"));
        Assert.assertThat((Object)testResult, this.matchesTestResult(new SingleTestResult(new Counts(0, 0, 1, 0), string, string2 + "\n<hr/><h1>out</h1>\n<pre>\nOut Message" + this.linebreak + "\n</pre>\n" + "\n<hr/><h1>err</h1>\n<pre>\nErr Message" + this.linebreak + "\n</pre>\n</body>", 0L)));
    }

    private Matcher<TestResult> matchesTestResult(TestResult testResult) {
        return new TestResultMatcher(testResult);
    }

    static class TestResultMatcher
    extends TypeSafeMatcher<TestResult> {
        private TestResult expected;

        public TestResultMatcher(TestResult testResult) {
            this.expected = testResult;
        }

        public boolean matchesSafely(TestResult testResult) {
            boolean bl;
            boolean bl2;
            boolean bl3 = this.expected.getName().equals(testResult.getName());
            if (!bl3) {
                System.out.println("Names don't match: '" + testResult.getName() + "' not as expected: '" + this.expected.getName());
            }
            if (!(bl2 = this.expected.getContent().equals(testResult.getContent()))) {
                System.out.println("Contents don't match: '\n" + testResult.getContent() + "\n' not as expected: '\n" + this.expected.getContent() + "\n'");
            }
            if (!(bl = this.expected.getCounts().equals(testResult.getCounts()))) {
                System.out.println("Counts don't match: '" + testResult.getCounts() + "' not as expected: '" + this.expected.getCounts());
            }
            return bl3 && bl2 && bl;
        }

        public void describeTo(Description description) {
            description.appendText(this.expected.getName());
        }
    }
}

