/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.batch.testRun;

import fit.Counts;
import fit.Fixture;
import fit.exception.FitParseException;
import fitlibrary.batch.testRun.FitLibraryBatching;
import fitlibrary.batch.trinidad.SingleTestResult;
import fitlibrary.batch.trinidad.TestDescriptor;
import fitlibrary.batch.trinidad.TestEngine;
import fitlibrary.batch.trinidad.TestResult;
import fitlibrary.runResults.TableListener;
import fitlibrary.suite.BatchFitLibrary;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class FitLibraryTestEngine
implements TestEngine {
    public static final String NOT_A_TEST = "NOT-A-TEST";
    private FitLibraryBatching batching;

    public FitLibraryTestEngine() {
        this(new FitLibraryBatchingImp());
    }

    public FitLibraryTestEngine(FitLibraryBatching batching) {
        this.batching = batching;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestResult runTest(TestDescriptor test) {
        PrintStream out = System.out;
        ByteArrayOutputStream tempOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(tempOut));
        PrintStream err = System.err;
        ByteArrayOutputStream tempErr = new ByteArrayOutputStream();
        System.setErr(new PrintStream(tempErr));
        try {
            TestResult testResult = this.runTest(test, tempOut, tempErr);
            return testResult;
        }
        finally {
            System.setOut(out);
            System.setErr(err);
        }
    }

    private TestResult runTest(TestDescriptor test, OutputStream out, OutputStream err) {
        String content = test.getContent();
        if (content.equals(NOT_A_TEST)) {
            return new SingleTestResult(new Counts(), test.getName(), " not a Test", 0L);
        }
        if (!content.contains("<table")) {
            return new SingleTestResult(new Counts(), test.getName(), " contains no tables", 0L);
        }
        try {
            long time = System.currentTimeMillis();
            Tables tables = TableFactory.tables(content);
            TableListener listener = new TableListener();
            this.batching.setCurrentPageName(test.getName());
            this.batching.doTables(tables, listener);
            String report = tables.report();
            report = this.add("out", out, report);
            report = this.add("err", err, report);
            return new SingleTestResult(listener.getTestResults().getCounts(), test.getName(), report, System.currentTimeMillis() - time);
        }
        catch (FitParseException e) {
            Counts counts = new Counts();
            counts.exceptions = 1;
            return new SingleTestResult(counts, test.getName(), e.toString(), 0L);
        }
    }

    private String add(String header, OutputStream out, String report) {
        String s = out.toString();
        if (s.equals("")) {
            return report;
        }
        int body = report.indexOf("<div class=\"footer\">");
        if (body < 0) {
            body = report.indexOf("</body");
        }
        if (body < 0) {
            body = report.length();
        }
        return report.substring(0, body) + "\n<hr/><h1>" + header + "</h1>\n<pre>\n" + Fixture.escape(s) + "\n</pre>\n" + report.substring(body);
    }

    static class FitLibraryBatchingImp
    implements FitLibraryBatching {
        BatchFitLibrary batching = new BatchFitLibrary();

        FitLibraryBatchingImp() {
        }

        @Override
        public void doTables(Tables tables, TableListener listener) {
            this.batching.doTables(tables, listener);
        }

        @Override
        public void setCurrentPageName(String name) {
            this.batching.setCurrentPageName(name);
        }
    }
}

