/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.batch.testRun;

import fit.Counts;
import fitlibrary.batch.fitnesseIn.ParallelFitNesseRepository;
import fitlibrary.batch.fitnesseIn.ParallelTestRepository;
import fitlibrary.batch.resultsOut.FolderTestResultRepository;
import fitlibrary.batch.resultsOut.ParallelFolderTestResultRepository;
import fitlibrary.batch.resultsOut.ParallelTestResultRepository;
import fitlibrary.batch.resultsOut.SuiteResult;
import fitlibrary.batch.trinidad.TestDescriptor;
import fitlibrary.batch.trinidad.TestEngine;
import fitlibrary.batch.trinidad.TestResult;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;

public class ParallelTestRunner {
    private ParallelTestRepository repository;
    private TestEngine testEngine;
    private ParallelTestResultRepository resultRepository;

    public ParallelTestRunner(ParallelTestRepository repository, TestEngine testEngine, String outputPath, boolean showPasses, String suiteName, boolean junitXMLOutput) throws IOException {
        this(repository, testEngine, new ParallelFolderTestResultRepository(new FolderTestResultRepository(outputPath, suiteName, System.out, showPasses, junitXMLOutput), Executors.newSingleThreadExecutor()));
    }

    public ParallelTestRunner(ParallelTestRepository repository, TestEngine testRunner, ParallelTestResultRepository resultRepository) throws IOException {
        this.repository = repository;
        this.testEngine = testRunner;
        this.resultRepository = resultRepository;
        repository.prepareResultRepository(resultRepository);
    }

    public Counts runTest(String testUrl) throws IOException {
        TestResult testResult = this.testEngine.runTest(this.repository.getTest(testUrl));
        this.resultRepository.recordTestResult(testResult);
        return testResult.getCounts();
    }

    public Counts runSuite(String suite, SuiteResult suiteResult) throws IOException, InterruptedException {
        TestDescriptor test;
        BlockingQueue<TestDescriptor> queue = this.repository.getSuite(suite);
        while (!ParallelFitNesseRepository.isSentinel(test = queue.take())) {
            if (test.getName().equals("Exception")) {
                throw new IOException(test.getContent());
            }
            TestResult result = this.testEngine.runTest(test);
            suiteResult.append(result);
            this.resultRepository.recordTestResult(result);
        }
        this.resultRepository.recordTestResult(suiteResult);
        this.resultRepository.closeAndWaitForCompletion();
        return suiteResult.getCounts();
    }
}

