/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.closure;

import fitlibrary.closure.Closure;
import fitlibrary.closure.FieldClosure;
import fitlibrary.closure.LookupClosure;
import fitlibrary.closure.MethodClosure;
import fitlibrary.exception.method.AmbiguousNameException;
import fitlibrary.special.DoAction;
import fitlibrary.traverse.workflow.DoEvaluator;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ClassUtility;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LookupClosureStandard
implements LookupClosure {
    private Map<MethodSignature, Object> mapMethodSignatureToMethod = new ConcurrentHashMap<MethodSignature, Object>(5000);
    private final Object NOT_FOUND = "";

    @Override
    public void mustBeThreadSafe() {
    }

    @Override
    public Closure findMethodClosure(TypedObject typedObject, String methodName, int argCount) {
        if (typedObject.isNull()) {
            return null;
        }
        Method chosenMethod = this.findMethod(typedObject.classType(), methodName, argCount, typedObject.getSubject());
        if (chosenMethod == null && this.aGetter(methodName, argCount)) {
            return this.findField(typedObject, this.extractFieldName(methodName));
        }
        if (chosenMethod == null) {
            return null;
        }
        return new MethodClosure(typedObject, chosenMethod);
    }

    @Override
    public Closure findPublicMethodClosure(TypedObject typedObject, String name, Class<?>[] argTypes) {
        if (typedObject.isNull()) {
            return null;
        }
        try {
            return new MethodClosure(typedObject, typedObject.classType().getMethod(name, argTypes));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean fitLibrarySystemMethod(Method method, int argCount, Object subject) {
        if (!ClassUtility.fitLibrarySystemMethod(method)) {
            return false;
        }
        if (subject instanceof DoEvaluator) {
            return !((DoEvaluator)subject).methodsThatAreVisible().contains(method.getName() + "/" + argCount);
        }
        return true;
    }

    protected Closure findField(TypedObject typedObject, String fieldName) {
        try {
            Class<?> type = typedObject.classType();
            return new FieldClosure(typedObject, type.getField(fieldName));
        }
        catch (Exception e) {
            return this.findPrivateField(typedObject, fieldName);
        }
    }

    protected Closure findPrivateField(TypedObject typedObject, String fieldName) {
        Class<?> type = typedObject.classType();
        Field[] declaredFields = type.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            Field field = declaredFields[i];
            if (!fieldName.equals(field.getName())) continue;
            field.setAccessible(true);
            return new FieldClosure(typedObject, field);
        }
        return null;
    }

    protected Method findMethod(Class<?> type, String name, int argCount, Object subject) {
        MethodSignature methodSignature = new MethodSignature(type, name, argCount);
        Object result = this.mapMethodSignatureToMethod.get(methodSignature);
        if (result != null) {
            if (result == this.NOT_FOUND) {
                return null;
            }
            return (Method)result;
        }
        Method chosenMethod = this.findSpecificMethod(type, name, argCount, subject);
        if (chosenMethod == null && (this.aGetter(name, argCount) || this.aSetter(name, argCount))) {
            chosenMethod = this.findPrivateMethod(type, name, argCount, subject);
        }
        if (chosenMethod == null) {
            this.mapMethodSignatureToMethod.put(methodSignature, this.NOT_FOUND);
        } else {
            this.mapMethodSignatureToMethod.put(methodSignature, chosenMethod);
        }
        return chosenMethod;
    }

    protected Method findSpecificMethod(Class<?> type, String name, int argCount, Object subject) {
        Method[] methods = type.getMethods();
        Method chosenMethod = null;
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!name.equals(method.getName()) || method.getParameterTypes().length != argCount || this.doActionMethod(method.getParameterTypes()) || this.fitLibrarySystemMethod(method, argCount, subject)) continue;
            if (chosenMethod == null) {
                chosenMethod = method;
                continue;
            }
            throw new AmbiguousNameException(name);
        }
        return chosenMethod;
    }

    private boolean doActionMethod(Class<?>[] parameterTypes) {
        for (Class<?> t : parameterTypes) {
            if (t != DoAction.class) continue;
            return true;
        }
        return false;
    }

    protected String extractFieldName(String methodName) {
        String fieldName = "";
        fieldName = methodName.startsWith("is") ? methodName.substring(2) : methodName.substring(3);
        fieldName = Character.toLowerCase(fieldName.charAt(0)) + fieldName.substring(1);
        return fieldName;
    }

    protected boolean aGetter(String name, int argCount) {
        boolean getter = name.startsWith("get") && name.length() > 3 && this.isUpper(name.charAt(3));
        boolean isa = name.startsWith("is") && name.length() > 2 && this.isUpper(name.charAt(2));
        return argCount == 0 && (getter || isa);
    }

    protected boolean isUpper(char ch) {
        return Character.isUpperCase(ch);
    }

    protected boolean aSetter(String name, int argCount) {
        return argCount == 1 && name.startsWith("set");
    }

    protected Method findPrivateMethod(Class<?> type, String name, int args, Object subject) {
        Method chosenMethod = this.findMethod(type.getDeclaredMethods(), name, args, subject);
        if (chosenMethod != null) {
            chosenMethod.setAccessible(true);
            return chosenMethod;
        }
        if (type.getSuperclass() != null) {
            return this.findPrivateMethod(type.getSuperclass(), name, args, subject);
        }
        return null;
    }

    protected Method findMethod(Method[] methods, String name, int args, Object subject) {
        Method chosenMethod = null;
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!name.equals(method.getName()) || method.getParameterTypes().length != args || this.doActionMethod(method.getParameterTypes()) || this.fitLibrarySystemMethod(method, args, subject)) continue;
            if (chosenMethod == null) {
                chosenMethod = method;
                continue;
            }
            throw new AmbiguousNameException(name);
        }
        return chosenMethod;
    }

    protected static class MethodSignature {
        private Class<?> type;
        private String name;
        private int args;

        public MethodSignature(Class<?> type, String name, int args) {
            this.type = type;
            this.name = name;
            this.args = args;
        }

        public boolean equals(Object object) {
            if (!(object instanceof MethodSignature)) {
                return false;
            }
            MethodSignature signature = (MethodSignature)object;
            return this.type == signature.type && this.name.equals(signature.name) && this.args == signature.args;
        }

        public int hashCode() {
            return this.type.hashCode() + this.name.hashCode() + this.args;
        }

        public String toString() {
            return this.type + "." + this.name + "(" + this.args + ")";
        }
    }
}

