/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.definedAction;

import fitlibrary.DefineAction;
import fitlibrary.batch.fitnesseIn.ParallelFitNesseRepository;
import fitlibrary.batch.trinidad.TestDescriptor;
import fitlibrary.definedAction.DefinedActionBodyCollector;
import fitlibrary.runResults.TestResultsFactory;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.utility.ParseUtility;
import java.io.File;
import java.util.concurrent.BlockingQueue;

public class DefineActionsOnPageSlowly {
    protected String topPageName;
    private static String FITNESSE_DIRY = ".";
    protected final RuntimeContextInternal runtime;

    public static void setFitNesseDiry(String diry) {
        FITNESSE_DIRY = diry;
    }

    public DefineActionsOnPageSlowly(String topPageName, RuntimeContextInternal runtime) {
        this.topPageName = topPageName;
        this.runtime = runtime;
    }

    public void process() throws Exception {
        this.processPages(this.topPageName.substring(1));
    }

    private void processPages(String pageName) throws Exception {
        TestDescriptor test;
        ParallelFitNesseRepository parallelFitNesseRepository = new ParallelFitNesseRepository(FITNESSE_DIRY);
        BlockingQueue<TestDescriptor> queue = parallelFitNesseRepository.getDefinedActions(pageName);
        while (!ParallelFitNesseRepository.isSentinel(test = queue.take())) {
            String html = ParseUtility.tabulize(test.getContent());
            if (!html.contains("<table")) continue;
            this.parseDefinitions(TableFactory.tables(html), this.determineClassName(pageName, test.getName()), test.getName());
        }
    }

    protected String determineClassName(String prefix, String pageName) {
        int nextDotPos;
        int classPos;
        String fullPageName = prefix + "." + pageName;
        if ("".equals(pageName)) {
            fullPageName = prefix;
        }
        if ((classPos = fullPageName.lastIndexOf(".Class")) >= 0 && (nextDotPos = fullPageName.indexOf(".", classPos + 1)) >= 0) {
            return fullPageName.substring(classPos + 6, nextDotPos);
        }
        return "";
    }

    protected void parseDefinitions(Tables tables, final String className, final String pageName) {
        new DefinedActionBodyCollector().parseDefinitions(tables, new DefinedActionBodyCollector.DefineActionBodyConsumer(){

            @Override
            public void addAction(Tables innerTables) {
                DefineActionsOnPageSlowly.this.defineAction(innerTables, className, pageName);
            }
        });
    }

    protected void defineAction(Tables innerTables, String className, String pageName) {
        DefineAction defineAction = new DefineAction(className, pageName);
        defineAction.setRuntimeContext(this.runtime);
        defineAction.define(this.createDefineActionTable(innerTables), TestResultsFactory.testResults());
    }

    private Table createDefineActionTable(Tables innerTables) {
        Table defineActionTable = TableFactory.table();
        Row row = TableFactory.row();
        row.addCell("DefineAction");
        defineActionTable.add(row);
        row = TableFactory.row();
        row.add(TableFactory.cell(innerTables));
        defineActionTable.add(row);
        return defineActionTable;
    }

    protected File fitNesseDiry() {
        return new File(FITNESSE_DIRY);
    }
}

