/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.definedAction;

import fitlibrary.definedAction.DefinedActionParameterTranslation;
import fitlibrary.dynamicVariable.GlobalDynamicVariables;
import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.matcher.TablesMatcher;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.utility.CollectionUtility;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestDefinedActionAutoTranslation {
    VariableResolver resolver = new GlobalDynamicVariables();

    @Before
    public void useListsFactory() {
        TableFactory.useOnLists(true);
    }

    @After
    public void stopUsingListsFactory() {
        TableFactory.pop();
    }

    @Test
    public void noNeedForAutoTranslationWithNoParameters() {
        Tables tables = (Tables)TableFactory.tables().add(TableFactory.table(TableFactory.row("a", "b", "c")));
        List<Object> list = CollectionUtility.list(new Object[0]);
        MatcherAssert.assertThat((Object)DefinedActionParameterTranslation.needToTranslateParameters(list, tables), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void noNeedForAutoTranslationWithOneParameterAlreadyInAtStyle() {
        Tables tables = (Tables)TableFactory.tables().add(TableFactory.table(TableFactory.row("@{A}", "b", "c")));
        List<String> list = CollectionUtility.list("A");
        MatcherAssert.assertThat((Object)DefinedActionParameterTranslation.needToTranslateParameters(list, tables), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void autoTranslationWithOneParameter() {
        Tables tables = this.tables("A", "b", "A c");
        List<String> list = CollectionUtility.list("A");
        MatcherAssert.assertThat((Object)DefinedActionParameterTranslation.needToTranslateParameters(list, tables), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(DefinedActionParameterTranslation.translateParameters(list, tables), (Matcher)CoreMatchers.is(CollectionUtility.list("paRameRer__0")));
        MatcherAssert.assertThat((Object)tables, (Matcher)new TablesMatcher(this.tables("@{paRameRer__0}", "b", "@{paRameRer__0} c"), this.resolver));
    }

    @Test
    public void autoTranslationWithOneParameterWithRegExp() {
        Tables tables = this.tables("A.* bc", "AAB", "c");
        MatcherAssert.assertThat(DefinedActionParameterTranslation.translateParameters(CollectionUtility.list("A.*"), tables), (Matcher)CoreMatchers.is(CollectionUtility.list("paRameRer__0")));
        MatcherAssert.assertThat((Object)tables, (Matcher)new TablesMatcher(this.tables("@{paRameRer__0} bc", "AAB", "c"), this.resolver));
    }

    @Test
    public void autoTranslationWithTwoParametersIsUnnecessary() {
        Tables tables = this.tables("@{A} bc", "@{A}@{A}@{B}", "c@{B}c");
        List<String> list = CollectionUtility.list("A", "B");
        MatcherAssert.assertThat((Object)DefinedActionParameterTranslation.needToTranslateParameters(list, tables), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void autoTranslationWithTwoParameters() {
        Tables tables = this.tables("A bc", "AAB", "cBc");
        List<String> list = CollectionUtility.list("A", "B");
        MatcherAssert.assertThat(DefinedActionParameterTranslation.translateParameters(list, tables), (Matcher)CoreMatchers.is(CollectionUtility.list("paRameRer__0", "paRameRer__1")));
        MatcherAssert.assertThat((Object)tables, (Matcher)new TablesMatcher(this.tables("@{paRameRer__0} bc", "@{paRameRer__0}@{paRameRer__0}@{paRameRer__1}", "c@{paRameRer__1}c"), this.resolver));
    }

    @Test
    public void autoTranslationWithTwoParametersWithOneASubstringOfTheOther() {
        Tables tables = this.tables("A bc AB", "AAB", "cBc");
        List<String> list = CollectionUtility.list("A", "AB");
        MatcherAssert.assertThat(DefinedActionParameterTranslation.translateParameters(list, tables), (Matcher)CoreMatchers.is(CollectionUtility.list("paRameRer__1", "paRameRer__0")));
        MatcherAssert.assertThat((Object)tables, (Matcher)new TablesMatcher(this.tables("@{paRameRer__1} bc @{paRameRer__0}", "@{paRameRer__1}@{paRameRer__0}", "cBc"), this.resolver));
    }

    private Tables tables(String ... stringArray) {
        return (Tables)TableFactory.tables().add(TableFactory.table(TableFactory.row(stringArray)));
    }
}

