/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.flow;

import fitlibrary.DomainFixture;
import fitlibrary.flow.DoFlowOnTable;
import fitlibrary.flow.DoFlowerOnTable;
import fitlibrary.flow.IScopeStack;
import fitlibrary.flow.IScopeState;
import fitlibrary.flow.SetUpTearDown;
import fitlibrary.global.TemporaryPlugBoardForRuntime;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.object.DomainCheckTraverse;
import fitlibrary.object.DomainInjectionTraverse;
import fitlibrary.object.DomainTraverser;
import fitlibrary.runResults.ITableListener;
import fitlibrary.runResults.TestResults;
import fitlibrary.runResults.TestResultsFactory;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.suite.SuiteEvaluator;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.DomainAdapter;
import fitlibrary.traverse.RuntimeContextual;
import fitlibrary.traverse.TableEvaluator;
import fitlibrary.traverse.workflow.FlowEvaluator;
import fitlibrary.traverse.workflow.PlainTextAnalyser;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.option.None;
import fitlibrary.utility.option.Option;
import fitlibrary.utility.option.Some;
import java.util.List;
import org.apache.log4j.Logger;

public class DoFlow
implements DomainTraverser,
TableEvaluator,
DoFlowOnTable.DoFlower {
    private static Logger logger = FitLibraryLogger.getLogger(DoFlow.class);
    private final IScopeStack scopeStack;
    protected RuntimeContextInternal runtime;
    private final SetUpTearDown setUpTearDown;
    private Option<SuiteEvaluator> suiteFixtureOption = None.none();
    private DomainInjectionTraverse domainInject = null;
    private DomainCheckTraverse domainCheck = null;
    private TableEvaluator current = this;
    private DoFlowerOnTable doFlowOnTable = null;

    public DoFlow(FlowEvaluator flowEvaluator, IScopeStack scopeStack, RuntimeContextInternal runtime, SetUpTearDown setUpTearDown) {
        this.scopeStack = scopeStack;
        this.runtime = runtime;
        this.setUpTearDown = setUpTearDown;
        this.doFlowOnTable = new DoFlowOnTable(flowEvaluator, scopeStack, setUpTearDown, this);
    }

    public void runStorytest(Tables tables, ITableListener tableListener) {
        logger.trace((Object)"Running storytest");
        TestResults testResults = tableListener.getTestResults();
        this.resetToStartStorytest();
        for (int t = 0; t < tables.size(); ++t) {
            Table table = (Table)tables.at(t);
            this.runSingleTable(testResults, table);
            if (t < tables.size() - 1) {
                this.finishTable(table, testResults);
            } else {
                this.finishLastTable(table, testResults);
            }
            this.addAccumulatedFoldingText(table);
            tableListener.tableFinished(table);
        }
        logger.trace((Object)"Finished storytest");
        tableListener.storytestFinished();
    }

    public void runSingleTable(TestResults testResults, Table table) {
        boolean plainTextFailed = false;
        if (this.current == this && table.isPlainTextTable()) {
            PlainTextAnalyser plainTextAnalyser = new PlainTextAnalyser(this.runtime, TemporaryPlugBoardForRuntime.definedActionsRepository());
            TestResults testResults2 = TestResultsFactory.testResults();
            plainTextAnalyser.analyseAndReplaceRowsIn(table, testResults2);
            plainTextFailed = testResults2.problems();
            testResults.add(testResults2);
        }
        if (this.domainCheck != null) {
            this.handleDomainPhases(table);
        }
        if (!plainTextFailed) {
            this.current.runTable(table, testResults);
        }
    }

    public void addAccumulatedFoldingText(Table table) {
        this.runtime.addAccumulatedFoldingText(table);
    }

    public void finishTable(Table table, TestResults testResults) {
        this.tearDown(this.scopeStack.poppedAtEndOfTable(), (Row)table.at(0), testResults);
        logger.trace((Object)"Finished table");
    }

    public void finishLastTable(Table table, TestResults testResults) {
        this.tearDown(this.scopeStack.poppedAtEndOfStorytest(), (Row)table.at(0), testResults);
        logger.trace((Object)"Finished last table");
    }

    @Override
    public void runTable(Table table, TestResults testResults) {
        this.doFlowOnTable.runTable(table, testResults, this.runtime);
    }

    public void resetToStartStorytest() {
        this.scopeStack.setAbandon(false);
        this.scopeStack.setStopOnError(false);
        this.scopeStack.clearAllButSuite();
        this.current = this;
        this.domainInject = null;
        this.domainCheck = null;
        if (this.suiteFixtureOption.isSome()) {
            logger.trace((Object)"Use suite fixture runtime");
            this.runtime = this.suiteFixtureOption.get().getCopyOfRuntimeContext();
            this.scopeStack.switchRuntime(this.runtime);
        } else {
            this.runtime.reset();
        }
    }

    private void handleDomainPhases(Table table) {
        int phaseBreaks = table.phaseBoundaryCount();
        if (phaseBreaks > 0) {
            for (int i = 0; i < phaseBreaks; ++i) {
                if (this.current == this.domainInject) {
                    this.setCurrentAction();
                    continue;
                }
                if (this.current != this) continue;
                this.setCurrentCheck();
            }
        }
    }

    @Override
    public void runInnerTables(Tables innerTables, TestResults testResults) {
        IScopeState state = this.scopeStack.currentState();
        for (Table iTable : innerTables) {
            this.runTable(iTable, testResults);
            this.tearDown(state.restore(), (Row)iTable.at(0), testResults);
        }
    }

    private void tearDown(List<TypedObject> typedObjects, Row row, TestResults testResults) {
        for (TypedObject typedObject : typedObjects) {
            this.setUpTearDown.callTearDownOnSutChain(typedObject.getSubject(), row, testResults);
        }
    }

    @Override
    public void setCurrentAction() {
        this.current = this;
    }

    @Override
    public void setCurrentCheck() {
        this.current = this.domainCheck;
    }

    public void exit() {
        if (this.suiteFixtureOption.isSome()) {
            this.setUpTearDown.callSuiteTearDown(this.suiteFixtureOption.get(), TestResultsFactory.testResults());
        }
    }

    public RuntimeContextInternal getRuntimeContext() {
        return this.runtime;
    }

    @Override
    public void addNamedObject(String name, TypedObject typedObject, Row row, TestResults testResults) {
        typedObject.injectRuntime(this.runtime);
        this.setUpTearDown.callSetUpOnSutChain(typedObject.getSubject(), row, testResults);
        this.scopeStack.addNamedObject(name, typedObject);
    }

    @Override
    public void select(String name) {
        this.scopeStack.select(name);
    }

    @Override
    public boolean hasDomainCheck() {
        return this.domainCheck != null;
    }

    @Override
    public void setDomainToCheck() {
        this.setCurrentCheck();
    }

    @Override
    public void setDomainFixture(TypedObject typedResult) {
        Object subject = typedResult.getSubject();
        TypedObject sut = typedResult;
        if (subject instanceof DomainFixture) {
            sut = ((DomainFixture)subject).getTypedSystemUnderTest();
        }
        this.domainInject = new DomainInjectionTraverse(this);
        this.domainInject.setTypedSystemUnderTest(sut);
        this.setRuntimeContextOf(this.domainInject);
        this.domainCheck = new DomainCheckTraverse(this);
        this.domainCheck.setTypedSystemUnderTest(sut);
        this.setRuntimeContextOf(this.domainCheck);
        this.current = this.domainInject;
    }

    @Override
    public void setSuite(SuiteEvaluator suiteEvaluator) {
        if (this.suiteFixtureOption.isNone()) {
            this.suiteFixtureOption = new Some<SuiteEvaluator>(suiteEvaluator);
        }
    }

    private void setRuntimeContextOf(Object object) {
        if (object instanceof RuntimeContextual) {
            ((RuntimeContextual)object).setRuntimeContext(this.runtime);
        }
        if (object instanceof DomainAdapter) {
            this.setRuntimeContextOf(((DomainAdapter)object).getSystemUnderTest());
        }
    }
}

