/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.flow;

import fit.Parse;
import fit.exception.FitParseException;
import fitlibrary.config.Configuration;
import fitlibrary.dynamicVariable.GlobalDynamicVariables;
import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.flow.DoFlow;
import fitlibrary.flow.IScopeStack;
import fitlibrary.flow.IScopeState;
import fitlibrary.flow.SetUpTearDown;
import fitlibrary.flow.TestDoFlowWithFixture;
import fitlibrary.runResults.ITableListener;
import fitlibrary.runResults.TestResults;
import fitlibrary.runResults.TestResultsFactory;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.suite.SuiteEvaluator;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.FitHandler;
import fitlibrary.traverse.RuntimeContextual;
import fitlibrary.traverse.workflow.FlowEvaluator;
import fitlibrary.typed.TypedObject;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.util.ArrayList;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.States;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.internal.StatePredicate;

public class DoFlowDriverForTests {
    final Mockery context;
    final FlowEvaluator flowEvaluator;
    final IScopeStack scopeStack;
    final TestResults testResults;
    final ITableListener tableListener;
    final RuntimeContextInternal runtime;
    final RuntimeContextInternal runtimeCopy;
    final SetUpTearDown setUpTearDown;
    final Configuration config;
    final VariableResolver resolver = new GlobalDynamicVariables();
    final States state;
    final DoFlow doFlow;
    static final String BEGIN_STATE = "begin";
    String currentState = "begin";
    int storytestNo = 0;
    int tableNo = 0;
    int rowNo = 0;
    public boolean showTearDown = false;

    public DoFlowDriverForTests(Mockery mockery) {
        this.context = mockery;
        this.flowEvaluator = (FlowEvaluator)mockery.mock(FlowEvaluator.class);
        this.scopeStack = (IScopeStack)mockery.mock(IScopeStack.class);
        this.testResults = TestResultsFactory.testResults();
        this.tableListener = (ITableListener)mockery.mock(ITableListener.class);
        this.runtime = (RuntimeContextInternal)mockery.mock(RuntimeContextInternal.class, "runtime");
        this.runtimeCopy = (RuntimeContextInternal)mockery.mock(RuntimeContextInternal.class, "runtimeCopy");
        this.setUpTearDown = (SetUpTearDown)mockery.mock(SetUpTearDown.class);
        this.config = (Configuration)mockery.mock(Configuration.class);
        this.state = mockery.states("doFlow").startsAs(BEGIN_STATE);
        this.doFlow = new DoFlow(this.flowEvaluator, this.scopeStack, this.runtime, this.setUpTearDown);
        this.startingStorytest();
    }

    public void runStorytest(Tables tables) {
        this.endingStorytest();
        this.doFlow.runStorytest(tables, this.tableListener);
    }

    public void exit() {
        this.doFlow.exit();
    }

    public void startingStorytest() {
        final String string = this.endState("startingStorytest");
        ++this.storytestNo;
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.allowing(DoFlowDriverForTests.this.runtime)).getConfiguration();
                this.will(1.returnValue((Object)DoFlowDriverForTests.this.config));
                ((RuntimeContextInternal)this.allowing(DoFlowDriverForTests.this.runtimeCopy)).getConfiguration();
                this.will(1.returnValue((Object)DoFlowDriverForTests.this.config));
                ((Configuration)this.allowing(DoFlowDriverForTests.this.config)).isAddTimings();
                this.will(1.returnValue((Object)false));
                ((ITableListener)this.allowing(DoFlowDriverForTests.this.tableListener)).getTestResults();
                this.will(1.returnValue((Object)DoFlowDriverForTests.this.testResults));
                ((RuntimeContextInternal)this.allowing(DoFlowDriverForTests.this.runtime)).getResolver();
                this.will(1.returnValue((Object)DoFlowDriverForTests.this.resolver));
                ((RuntimeContextInternal)this.allowing(DoFlowDriverForTests.this.runtimeCopy)).getResolver();
                this.will(1.returnValue((Object)DoFlowDriverForTests.this.resolver));
                ((IScopeStack)this.oneOf(DoFlowDriverForTests.this.scopeStack)).setAbandon(false);
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((IScopeStack)this.oneOf(DoFlowDriverForTests.this.scopeStack)).setStopOnError(false);
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((IScopeStack)this.oneOf(DoFlowDriverForTests.this.scopeStack)).clearAllButSuite();
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((RuntimeContextInternal)this.oneOf(DoFlowDriverForTests.this.runtime)).reset();
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    private void endingStorytest() {
        --this.storytestNo;
        final String string = this.endState("endingStorytest");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ITableListener)this.oneOf(DoFlowDriverForTests.this.tableListener)).storytestFinished();
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public RuntimeContextInternal startingStorytestWithSuite(final SuiteEvaluator suiteEvaluator) {
        final String string = this.endState("startingStorytestWithSuite");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ITableListener)this.allowing(DoFlowDriverForTests.this.tableListener)).getTestResults();
                this.will(3.returnValue((Object)DoFlowDriverForTests.this.testResults));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((IScopeStack)this.oneOf(DoFlowDriverForTests.this.scopeStack)).setAbandon(false);
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((IScopeStack)this.oneOf(DoFlowDriverForTests.this.scopeStack)).setStopOnError(false);
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((IScopeStack)this.oneOf(DoFlowDriverForTests.this.scopeStack)).clearAllButSuite();
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((SuiteEvaluator)this.oneOf(suiteEvaluator)).getCopyOfRuntimeContext();
                this.will(3.returnValue((Object)DoFlowDriverForTests.this.runtimeCopy));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((IScopeStack)this.oneOf(DoFlowDriverForTests.this.scopeStack)).switchRuntime(DoFlowDriverForTests.this.runtimeCopy);
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
        return this.runtimeCopy;
    }

    public void startingOnTable(Table table) {
        this.startingOnTable(table, this.runtime);
    }

    public void startingOnTable(final Table table, final RuntimeContextInternal runtimeContextInternal) {
        ++this.tableNo;
        final String string = this.endState("startingOnTable");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Table)this.allowing(table)).isPlainTextTable();
                this.will(4.returnValue((Object)false));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((RuntimeContextInternal)this.oneOf(runtimeContextInternal)).setCurrentTable(table);
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((ITableListener)this.allowing(DoFlowDriverForTests.this.tableListener)).getTestResults();
                this.will(4.returnValue((Object)DoFlowDriverForTests.this.testResults));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((RuntimeContextInternal)this.oneOf(runtimeContextInternal)).pushTestResults((TestResults)this.with(4.any(TestResults.class)));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void poppingAtEndOfTable() {
        this.poppingScopeStackAtEndOfTable(this.runtime);
    }

    public void poppingScopeStackAtEndOfTable(List<Object> list) {
        this.poppingScopeStackAtEndOfTable(this.runtime, list);
    }

    public void poppingScopeStackAtEndOfTable(RuntimeContextInternal runtimeContextInternal) {
        this.poppingScopeStackAtEndOfTable(runtimeContextInternal, new ArrayList<Object>());
    }

    public void poppingScopeStackAtEndOfTable(final RuntimeContextInternal runtimeContextInternal, List<Object> list) {
        final List<TypedObject> list2 = this.asTypedObjects(list);
        final String string = this.endState("poppingScopeStackAtEndOfTable");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.oneOf(runtimeContextInternal)).popTestResults();
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((IScopeStack)this.oneOf(DoFlowDriverForTests.this.scopeStack)).poppedAtEndOfTable();
                this.will(5.returnValue((Object)list2));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void poppingScopeStackAtEndOfLastTableGiving() {
        this.poppingScopeStackAtEndOfLastTableGiving(this.runtime);
    }

    public void poppingScopeStackAtEndOfLastTableGiving(RuntimeContextInternal runtimeContextInternal) {
        this.poppingScopeStackAtEndOfLastTableGiving(runtimeContextInternal, new ArrayList<Object>());
    }

    public void poppingScopeStackAtEndOfLastTableGiving(List<Object> list) {
        this.poppingScopeStackAtEndOfLastTableGiving(this.runtime, list);
    }

    public void poppingScopeStackAtEndOfLastTableGiving(final RuntimeContextInternal runtimeContextInternal, List<Object> list) {
        final List<TypedObject> list2 = this.asTypedObjects(list);
        final String string = this.endState("poppingScopeStackAtEndOfLastTableGiving");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.oneOf(runtimeContextInternal)).popTestResults();
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((IScopeStack)this.oneOf(DoFlowDriverForTests.this.scopeStack)).poppedAtEndOfStorytest();
                this.will(6.returnValue((Object)list2));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void finishingTable(Table table) {
        this.finishingTable(table, this.runtime);
    }

    public void finishingTable(final Table table, final RuntimeContextInternal runtimeContextInternal) {
        final String string = this.endState("finishingTable");
        --this.tableNo;
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.oneOf(runtimeContextInternal)).addAccumulatedFoldingText(table);
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((ITableListener)this.oneOf(DoFlowDriverForTests.this.tableListener)).tableFinished(table);
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void finishingLastTable() {
        final String string = this.endState("finishingLastTable");
        --this.tableNo;
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.oneOf(DoFlowDriverForTests.this.runtime)).addAccumulatedFoldingText((Table)this.with(8.any(Table.class)));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((ITableListener)this.oneOf(DoFlowDriverForTests.this.tableListener)).tableFinished((Table)this.with(8.any(Table.class)));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void interpretingRowReturning(Row row, Object object) {
        this.interpretingRowReturning(row, object, this.runtime);
    }

    public void interpretingRowReturning(final Row row, final Object object, final RuntimeContextInternal runtimeContextInternal) {
        ++this.rowNo;
        final String string = this.endState("interpretingRowReturning");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.allowing(runtimeContextInternal)).isAbandoned((TestResults)this.with(9.any(TestResults.class)));
                this.will(9.returnValue((Object)false));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((RuntimeContextInternal)this.oneOf(runtimeContextInternal)).setCurrentRow(row);
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((FlowEvaluator)this.oneOf(DoFlowDriverForTests.this.flowEvaluator)).interpretRow(row, DoFlowDriverForTests.this.testResults);
                this.will(9.returnValue((Object)new GenericTypedObject(object)));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void pushingObjectOnScopeStack(final Object object) {
        final String string = this.endState("pushingObjectOnScopeStack");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((IScopeStack)this.oneOf(DoFlowDriverForTests.this.scopeStack)).push(new GenericTypedObject(object));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void callingSuiteSetUpOn(final Object object, final Row row) {
        final String string = this.endState("callingSuiteSetUpOn");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SetUpTearDown)this.oneOf(DoFlowDriverForTests.this.setUpTearDown)).callSuiteSetUp(object, row, DoFlowDriverForTests.this.testResults);
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void callingSuiteTearDownOn(final Object object) {
        final String string = this.endState("callingSuiteTearDownOn");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SetUpTearDown)this.oneOf(DoFlowDriverForTests.this.setUpTearDown)).callSuiteTearDown(this.with(object), (TestResults)this.with(12.any(TestResults.class)));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void callingSetUpOn(final Object object, final Row row) {
        final String string = this.endState("callingSetUpOn");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SetUpTearDown)this.oneOf(DoFlowDriverForTests.this.setUpTearDown)).callSetUpOnSutChain(object, row, DoFlowDriverForTests.this.testResults);
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void callingTearDownOn(final Object object, final Row row) {
        final String string = this.endState("callingTearDownOn");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SetUpTearDown)this.oneOf(DoFlowDriverForTests.this.setUpTearDown)).callTearDownOnSutChain(object, row, DoFlowDriverForTests.this.testResults);
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    private List<TypedObject> asTypedObjects(List<Object> list) {
        ArrayList<TypedObject> arrayList = new ArrayList<TypedObject>();
        for (Object object : list) {
            arrayList.add(new GenericTypedObject(object));
        }
        return arrayList;
    }

    public void interpretingFixture(final TestDoFlowWithFixture.MockFixture mockFixture, final Table table) throws FitParseException {
        final Parse parse = new Parse("<table><tr><td>1</td></tr></table>");
        final String string = this.endState("interpretingFixture" + this.tableNo);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Table)this.oneOf(table)).asTableOnParse();
                this.will(15.returnValue((Object)table));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((FlowEvaluator)this.oneOf(DoFlowDriverForTests.this.flowEvaluator)).fitHandler();
                this.will(15.returnValue((Object)new FitHandler()));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((Table)this.oneOf(table)).asParse();
                this.will(15.returnValue((Object)parse));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((TestDoFlowWithFixture.MockFixture)this.oneOf(mockFixture)).doTable(parse);
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((Table)this.oneOf(table)).replaceAt(0, (Row)table.at(0));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((Table)this.oneOf(table)).replaceAt(1, (Row)table.at(1));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void interpretingEvaluator(final Evaluator evaluator, final Table table) {
        final String string = this.endState("interpretingEvaluator");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Evaluator)this.oneOf(evaluator)).interpretAfterFirstRow(table, DoFlowDriverForTests.this.testResults);
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public RuntimeContextInternal getRuntime() {
        return this.runtime;
    }

    public void injectingWithRuntime(final RuntimeContextual runtimeContextual) {
        final String string = this.endState("injectingWithRuntime");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextual)this.oneOf(runtimeContextual)).setRuntimeContext(DoFlowDriverForTests.this.runtime);
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public IScopeState startingOnInnerTablesWithCurrentScopeState() {
        return this.startingOnInnerTablesWithCurrentScopeState(this.runtime);
    }

    public IScopeState startingOnInnerTablesWithCurrentScopeState(final RuntimeContextInternal runtimeContextInternal) {
        final IScopeState iScopeState = (IScopeState)this.context.mock(IScopeState.class);
        final String string = this.endState("startingOnInnerTables");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.allowing(runtimeContextInternal)).isAbandoned((TestResults)this.with(18.any(TestResults.class)));
                this.will(18.returnValue((Object)false));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((IScopeStack)this.oneOf(DoFlowDriverForTests.this.scopeStack)).currentState();
                this.will(18.returnValue((Object)iScopeState));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
        return iScopeState;
    }

    private String endState(String string) {
        return string + "." + this.storytestNo + "." + this.tableNo + "." + this.rowNo;
    }

    public void restoringScopeGiving(IScopeState iScopeState, List<Object> list) {
        this.restoringScope(iScopeState, list, this.runtime);
    }

    public void restoringScope(final IScopeState iScopeState, List<Object> list, final RuntimeContextInternal runtimeContextInternal) {
        final List<TypedObject> list2 = this.asTypedObjects(list);
        final String string = this.endState("restoring");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.oneOf(runtimeContextInternal)).popTestResults();
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                ((IScopeState)this.oneOf(iScopeState)).restore();
                this.will(19.returnValue((Object)list2));
                this.when((StatePredicate)DoFlowDriverForTests.this.state.is(DoFlowDriverForTests.this.currentState));
                this.then(DoFlowDriverForTests.this.state.is(string));
            }
        });
        this.currentState = string;
    }
}

