/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.flow;

import fit.Fixture;
import fitlibrary.DoFixture;
import fitlibrary.SelectFixture;
import fitlibrary.flow.DoFlowDriverForTests;
import fitlibrary.matcher.TableBuilderForTests;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.DomainAdapter;
import fitlibrary.traverse.workflow.DoEvaluator;
import fitlibrary.traverse.workflow.DoTraverse;
import fitlibrary.utility.CollectionUtility;
import java.awt.Point;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestDoFlow {
    final Mockery context = new Mockery();
    final DoFlowDriverForTests driver = new DoFlowDriverForTests(this.context);
    final Tables tables = this.makeTables();

    @Test
    public void nullSoNoScopeChange() {
        this.verifyNoScopeChangeWith(null);
    }

    @Test
    public void anObjectOfTheClassFixtureSoNoScopeChange() {
        this.verifyNoScopeChangeWith(new Fixture());
    }

    @Test
    public void aNonWrappableSoNoScopeChange() {
        this.verifyNoScopeChangeWith("string");
    }

    @Test
    public void anObjectOfTheClassDoFixtureWithNoSutSoNoScopeChange() {
        this.verifyNoScopeChangeWith(new DoFixture());
    }

    @Test
    public void aDoTraverseWithNoSutSoNoScopeChange() {
        this.verifyNoScopeChangeWith(new DoTraverse());
    }

    @Test
    public void aSelectFixtureWithNoSutSoNoScopeChange() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.exactly(2).of((Object)TestDoFlow.this.driver.getRuntime())).showAsAfterTable((String)this.with(1.any(String.class)), (String)this.with(1.any(String.class)));
            }
        });
        this.verifyNoScopeChangeWith(new SelectFixture());
    }

    @Test
    public void aDoTraverseWithSutSoScopeChange() {
        this.verifyScopePush(new DoTraverse(new Point()), new Point());
    }

    @Test
    public void aPojoWithSutSoScopeChange() {
        PojoWithSut pojoWithSut = new PojoWithSut();
        this.verifyScopePush(new DoTraverse(pojoWithSut), pojoWithSut);
    }

    @Test
    public void aDoEvaluatorSoScopeChange() {
        final DoEvaluatorExample doEvaluatorExample = (DoEvaluatorExample)this.context.mock(DoEvaluatorExample.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoEvaluatorExample)this.exactly(2).of((Object)doEvaluatorExample)).setRuntimeContext((RuntimeContextInternal)this.with(2.aNonNull(RuntimeContextInternal.class)));
                ((DoEvaluatorExample)this.allowing(doEvaluatorExample)).getSystemUnderTest();
                this.will(2.returnValue(null));
            }
        });
        this.verifyScopePush(doEvaluatorExample, doEvaluatorExample);
    }

    @Test
    public void aDoEvaluatorWithSetUpTearDownSoScopeChange() {
        final DoEvaluator doEvaluator = (DoEvaluator)this.context.mock(DoEvaluator.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoEvaluator)this.exactly(2).of((Object)doEvaluator)).setRuntimeContext((RuntimeContextInternal)this.with(3.aNonNull(RuntimeContextInternal.class)));
                ((DoEvaluator)this.allowing(doEvaluator)).getSystemUnderTest();
                this.will(3.returnValue(null));
            }
        });
        this.verifyScopePush(doEvaluator, doEvaluator);
    }

    @Test
    public void twoDoTraversesSoScopeStackChange() {
        String string = "s";
        String string2 = "t";
        DoTraverse doTraverse = new DoTraverse(string);
        DoTraverse doTraverse2 = new DoTraverse(string2);
        Table table = (Table)this.tables.at(0);
        Table table2 = (Table)this.tables.at(1);
        this.driver.startingOnTable(table);
        this.driver.interpretingRowReturning((Row)table.at(0), doTraverse);
        this.driver.pushingObjectOnScopeStack(string);
        this.driver.callingSetUpOn(string, (Row)table.at(0));
        this.driver.interpretingRowReturning((Row)table.at(1), doTraverse2);
        this.driver.pushingObjectOnScopeStack(string2);
        this.driver.callingSetUpOn(string2, (Row)table.at(1));
        this.driver.poppingScopeStackAtEndOfTable(this.list(string2, string));
        this.driver.callingTearDownOn(string2, (Row)table.at(0));
        this.driver.callingTearDownOn(string, (Row)table.at(0));
        this.driver.finishingTable(table);
        this.driver.startingOnTable(table2);
        this.driver.interpretingRowReturning((Row)table2.at(0), doTraverse);
        this.driver.pushingObjectOnScopeStack(string);
        this.driver.callingSetUpOn(string, (Row)table2.at(0));
        this.driver.interpretingRowReturning((Row)table2.at(1), doTraverse2);
        this.driver.pushingObjectOnScopeStack(string2);
        this.driver.callingSetUpOn(string2, (Row)table2.at(1));
        this.driver.poppingScopeStackAtEndOfLastTableGiving(this.list(string2, string));
        this.driver.callingTearDownOn(string2, (Row)table2.at(0));
        this.driver.callingTearDownOn(string, (Row)table2.at(0));
        this.driver.finishingTable(table2);
        this.driver.runStorytest(this.tables);
    }

    private void verifyScopePush(Object object, Object object2) {
        Table table = (Table)this.tables.at(0);
        Table table2 = (Table)this.tables.at(1);
        this.driver.startingOnTable(table);
        this.driver.interpretingRowReturning((Row)table.at(0), object);
        this.driver.pushingObjectOnScopeStack(object2);
        this.driver.callingSetUpOn(object2, (Row)table.at(0));
        this.driver.interpretingRowReturning((Row)table.at(1), null);
        this.driver.poppingScopeStackAtEndOfTable(this.list(object));
        this.driver.callingTearDownOn(object, (Row)table.at(0));
        this.driver.finishingTable(table);
        this.driver.startingOnTable(table2);
        this.driver.interpretingRowReturning((Row)table2.at(0), object);
        this.driver.pushingObjectOnScopeStack(object2);
        this.driver.callingSetUpOn(object2, (Row)table2.at(0));
        this.driver.interpretingRowReturning((Row)table2.at(1), null);
        this.driver.poppingScopeStackAtEndOfLastTableGiving(this.list(object));
        this.driver.callingTearDownOn(object, (Row)table2.at(0));
        this.driver.finishingTable(table2);
        this.driver.runStorytest(this.tables);
    }

    private void verifyNoScopeChangeWith(Object object) {
        Table table = (Table)this.tables.at(0);
        Table table2 = (Table)this.tables.at(1);
        this.driver.startingOnTable(table);
        this.driver.interpretingRowReturning((Row)table.at(0), object);
        this.driver.interpretingRowReturning((Row)table.at(1), null);
        this.driver.poppingAtEndOfTable();
        this.driver.finishingTable(table);
        this.driver.startingOnTable(table2);
        this.driver.interpretingRowReturning((Row)table2.at(0), object);
        this.driver.interpretingRowReturning((Row)table2.at(1), null);
        this.driver.poppingScopeStackAtEndOfLastTableGiving();
        this.driver.finishingTable(table2);
        this.driver.runStorytest(this.tables);
    }

    private Tables makeTables() {
        return (Tables)TableBuilderForTests.tables().with(this.tableWith2RowsOf2(), this.tableWith2RowsOf2()).mock(this.context);
    }

    private TableBuilderForTests.TableBuilder tableWith2RowsOf2() {
        return TableBuilderForTests.table().with(TableBuilderForTests.row().with(TableBuilderForTests.cell(), TableBuilderForTests.cell()), TableBuilderForTests.row().with(TableBuilderForTests.cell(), TableBuilderForTests.cell()));
    }

    protected List<Object> list(Object ... objectArray) {
        return CollectionUtility.list(objectArray);
    }

    static interface DoEvaluatorExample
    extends DoEvaluator {
    }

    static class PojoWithSut
    implements DomainAdapter {
        PojoWithSut() {
        }

        @Override
        public Object getSystemUnderTest() {
            return new Point();
        }
    }
}

