/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.log;

import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.Transform;
import org.apache.log4j.spi.LoggingEvent;

public class CustomHtmlLayout
extends Layout {
    public static int MAX_LOGGED_SIZE = 400;
    protected final int BUF_SIZE = 256;
    protected final int MAX_CAPACITY = 1024;
    static String TRACE_PREFIX = "<br>&nbsp;&nbsp;&nbsp;&nbsp;";
    private StringBuffer sbuf = new StringBuffer(256);

    public String getContentType() {
        return "text/html";
    }

    public void activateOptions() {
    }

    public String format(LoggingEvent event) {
        if (this.sbuf.capacity() > 1024) {
            this.sbuf = new StringBuffer(256);
        } else {
            this.sbuf.setLength(0);
        }
        this.sbuf.append(Layout.LINE_SEP + "<tr>" + Layout.LINE_SEP);
        this.sbuf.append("<td>");
        this.sbuf.append(event.timeStamp - LoggingEvent.getStartTime());
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        String escapedThread = Transform.escapeTags((String)event.getThreadName());
        this.sbuf.append("<td style=\"font-size : xx-small;\" title=\"" + escapedThread + " thread\">");
        if (!escapedThread.equals("main")) {
            this.sbuf.append(escapedThread);
        }
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        this.sbuf.append("<td style=\"font-size : x-small;\" title=\"Level\">");
        if (event.getLevel().equals((Object)Level.DEBUG)) {
            this.sbuf.append("<font color=\"#339933\">");
            this.sbuf.append(Transform.escapeTags((String)String.valueOf(event.getLevel())));
            this.sbuf.append("</font>");
        } else if (event.getLevel().isGreaterOrEqual((Priority)Level.WARN)) {
            this.sbuf.append("<font color=\"#993300\"><strong>");
            this.sbuf.append(Transform.escapeTags((String)String.valueOf(event.getLevel())));
            this.sbuf.append("</strong></font>");
        } else {
            this.sbuf.append(Transform.escapeTags((String)String.valueOf(event.getLevel())));
        }
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        String escapedLogger = Transform.escapeTags((String)event.getLoggerName());
        this.sbuf.append("<td title=\"" + escapedLogger + " category\">");
        this.sbuf.append(escapedLogger);
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        this.sbuf.append("<td style=\"font-size : xx-small;\" colspan=\"6\" title=\"Nested Diagnostic Context\">");
        if (event.getNDC() != null) {
            this.sbuf.append(Transform.escapeTags((String)event.getNDC()));
        }
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        this.sbuf.append("<td title=\"Message\">");
        this.sbuf.append(CustomHtmlLayout.limitSize(Transform.escapeTags((String)event.getRenderedMessage())));
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        this.sbuf.append("</tr>" + Layout.LINE_SEP);
        String[] s = event.getThrowableStrRep();
        if (s != null) {
            this.sbuf.append("<tr><td bgcolor=\"#993300\" style=\"color:White; font-size : xx-small;\" colspan=\"6\">");
            this.appendThrowableAsHTML(s, this.sbuf);
            this.sbuf.append("</td></tr>" + Layout.LINE_SEP);
        }
        return this.sbuf.toString();
    }

    private static String limitSize(String s) {
        int size = s.length();
        if (size <= MAX_LOGGED_SIZE) {
            return s;
        }
        return s.substring(0, MAX_LOGGED_SIZE - 30) + "..." + s.substring(size - 27);
    }

    void appendThrowableAsHTML(String[] s, StringBuffer sbuffer) {
        if (s != null) {
            int len = s.length;
            if (len == 0) {
                return;
            }
            sbuffer.append(Transform.escapeTags((String)s[0]));
            sbuffer.append(Layout.LINE_SEP);
            for (int i = 1; i < len; ++i) {
                sbuffer.append(TRACE_PREFIX);
                sbuffer.append(Transform.escapeTags((String)s[i]));
                sbuffer.append(Layout.LINE_SEP);
            }
        }
    }

    public String getHeader() {
        return "";
    }

    public String getFooter() {
        return "";
    }

    public boolean ignoresThrowable() {
        return false;
    }
}

