/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.matcher;

import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.matcher.TableElementBuilder;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.utility.option.None;
import fitlibrary.utility.option.Option;
import fitlibrary.utility.option.Some;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;

public class TableBuilderForTests {
    public static TablesBuilder tables() {
        return new TablesBuilder();
    }

    public static TableBuilder table() {
        return new TableBuilder();
    }

    public static RowBuilder row() {
        return new RowBuilder();
    }

    public static CellBuilder cell() {
        return new CellBuilder();
    }

    public static CellBuilder cell(String text) {
        return new CellBuilder(text);
    }

    public static class CellBuilder
    extends TableElementBuilder<Cell, TableBuilder, Table> {
        protected Option<String> optionalText = None.none();

        public CellBuilder() {
            super(Cell.class);
        }

        public CellBuilder(Option<String> optionalText) {
            super(Cell.class);
            this.optionalText = optionalText;
        }

        public CellBuilder(String text) {
            this(new Some<String>(text));
        }

        @Override
        public Cell mock(Mockery context, String path, int index) {
            final Cell cell = (Cell)super.mock(context, path, index);
            final String text = this.optionalText.isSome() ? this.optionalText.get() : this.localPath(path, index);
            context.checking((ExpectationBuilder)new Expectations(){
                {
                    ((Cell)this.allowing(cell)).text();
                    this.will(1.returnValue((Object)text));
                    ((Cell)this.allowing(cell)).fullText();
                    this.will(1.returnValue((Object)text));
                    ((Cell)this.allowing(cell)).text((VariableResolver)this.with(1.any(VariableResolver.class)));
                    this.will(1.returnValue((Object)text));
                    ((Cell)this.allowing(cell)).hasEmbeddedTables((VariableResolver)this.with(1.any(VariableResolver.class)));
                    this.will(1.returnValue((Object)(!cell.isEmpty() ? 1 : 0)));
                    ((Cell)this.allowing(cell)).getEmbeddedTables();
                    this.will(1.returnValue((Object)cell));
                    ((Cell)this.allowing(cell)).getActualEmbeddedTables();
                    this.will(1.returnValue((Object)cell));
                }
            });
            return cell;
        }

        public CellBuilder with(TableBuilder ... els) {
            CellBuilder fresh = new CellBuilder(this.optionalText);
            this.with(fresh, els);
            return fresh;
        }

        public CellBuilder withTagLine(String tagLiner) {
            CellBuilder fresh = new CellBuilder(this.optionalText);
            this.withTagLine(fresh, tagLiner);
            return fresh;
        }
    }

    public static class RowBuilder
    extends TableElementBuilder<Row, CellBuilder, Cell> {
        public RowBuilder() {
            super(Row.class);
        }

        public RowBuilder with(CellBuilder ... els) {
            RowBuilder fresh = new RowBuilder();
            this.with(fresh, els);
            return fresh;
        }

        public RowBuilder withLeader(String lead) {
            RowBuilder fresh = new RowBuilder();
            this.withLeader(fresh, lead);
            return fresh;
        }
    }

    public static class TableBuilder
    extends TableElementBuilder<Table, RowBuilder, Row> {
        public TableBuilder() {
            super(Table.class);
        }

        public TableBuilder with(RowBuilder ... els) {
            TableBuilder fresh = new TableBuilder();
            this.with(fresh, els);
            return fresh;
        }

        public TableBuilder withLeader(String lead) {
            TableBuilder fresh = new TableBuilder();
            this.withLeader(fresh, lead);
            return fresh;
        }

        public TableBuilder withTrailer(String trail) {
            TableBuilder fresh = new TableBuilder();
            this.withTrailer(fresh, trail);
            return fresh;
        }
    }

    public static class TablesBuilder
    extends TableElementBuilder<Tables, TableBuilder, Table> {
        public TablesBuilder() {
            super(Tables.class);
        }

        public TablesBuilder with(TableBuilder ... els) {
            TablesBuilder fresh = new TablesBuilder();
            this.with(fresh, els);
            return fresh;
        }
    }
}

