/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.collection;

import fitlibrary.collection.CollectionSetUpTraverse;
import fitlibrary.collection.CollectionTraverse;
import fitlibrary.collection.list.ListTraverse;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.ParserFactory;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.FitLibrarySelector;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.CollectionUtility;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class ListParser
implements Parser {
    protected Parser valueParser;
    protected Parser showParser;
    protected final Evaluator evaluator;
    private final Typed typed;

    public ListParser(Evaluator evaluator, Typed typed) {
        if (evaluator.getRuntimeContext() == null) {
            throw new NullPointerException("Runtime is null");
        }
        this.evaluator = evaluator;
        this.typed = typed;
        this.valueParser = Traverse.asTyped(String.class).resultParser(evaluator);
        this.showParser = Traverse.asTyped(Object.class).resultParser(evaluator);
    }

    public static boolean applicableType(Class<?> type) {
        return Collection.class.isAssignableFrom(type) || Iterator.class.isAssignableFrom(type) || type.isArray();
    }

    @Override
    public TypedObject parseTyped(Cell cell, TestResults testResults) throws Exception {
        return this.typed.typedObject(this.parse(cell, testResults));
    }

    private Object parse(Cell cell, TestResults testResults) throws Exception {
        List<Object> results = null;
        results = cell.hasEmbeddedTables(this.evaluator) ? this.parseTable(cell.getEmbeddedTable(), testResults) : this.parse(cell.text(this.evaluator), testResults);
        if (this.typed.isArray()) {
            return this.asArray(this.typed.getComponentTyped().asClass(), results);
        }
        if (this.isIterator()) {
            return results.iterator();
        }
        return results;
    }

    private boolean isIterator() {
        return Iterator.class.isAssignableFrom(this.typed.asClass());
    }

    protected List<Object> parseTable(Table table, TestResults testResults) {
        ArrayList<Object> list = new ArrayList<Object>();
        CollectionSetUpTraverse setUp = new CollectionSetUpTraverse(this.evaluator, list, true);
        setUp.interpretInnerTableWithInScope(table, this.evaluator.getRuntimeContext(), testResults);
        return list;
    }

    private Object asArray(Class<?> componentType, List<Object> results) {
        Object array = Array.newInstance(componentType, results.size());
        int i = 0;
        Iterator<Object> it = results.iterator();
        while (it.hasNext()) {
            Array.set(array, i++, it.next());
        }
        return array;
    }

    @Override
    public boolean matches(Cell cell, Object actual, TestResults testResults) throws Exception {
        if (actual == null) {
            return !cell.hasEmbeddedTables(this.evaluator) && cell.isBlank(this.evaluator);
        }
        if (cell.hasEmbeddedTables(this.evaluator)) {
            return this.tableMatches(cell.getEmbeddedTable(), actual, testResults);
        }
        Object expected = this.parse(cell, testResults);
        if (this.isIterator()) {
            return CollectionUtility.equalsIterator((Iterator)expected, ((List)actual).iterator());
        }
        if (this.typed.isArray()) {
            return Arrays.equals((Object[])expected, (Object[])actual);
        }
        return expected.equals(actual);
    }

    protected boolean tableMatches(Table table, Object result, TestResults testResults) {
        CollectionTraverse traverse = FitLibrarySelector.selectOrderedList(result);
        return traverse.doesInnerTablePass(table, this.evaluator.getRuntimeContext(), testResults);
    }

    protected List<Object> parse(String s, TestResults testResults) throws Exception {
        StringTokenizer tokeniser = new StringTokenizer(s, ",");
        ArrayList<Object> list = new ArrayList<Object>();
        while (tokeniser.hasMoreTokens()) {
            list.add(this.valueParser.parseTyped(TableFactory.cell(tokeniser.nextToken()), testResults).getSubject());
        }
        return list;
    }

    @Override
    public String show(Object object) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, Exception {
        String result = "";
        if (object == null) {
            return result;
        }
        Iterator<Object> it = object.getClass().isArray() ? Arrays.asList((Object[])object).iterator() : ((List)object).iterator();
        boolean first = true;
        while (it.hasNext()) {
            String element = this.showParser.show(it.next());
            if (first) {
                first = false;
            } else {
                result = result + ", ";
            }
            result = result + element;
        }
        return result;
    }

    public static ParserFactory parserFactory() {
        return new ParserFactory(){

            @Override
            public Parser parser(Evaluator evaluator, Typed typed) {
                return new ListParser(evaluator, typed);
            }
        };
    }

    @Override
    public Evaluator traverse(TypedObject typedObject) {
        return new ListTraverse((Object)typedObject);
    }
}

