/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runner;

import fit.Counts;
import fit.Parse;
import fitlibrary.runner.FileParseUtilities;
import fitlibrary.runner.HtmlRunner;
import fitlibrary.runner.Report;
import fitlibrary.runner.SpreadsheetRunner;
import fitlibrary.runner.StoryTestListener;
import fitlibrary.suite.BatchFitLibrary;
import fitlibrary.traverse.Traverse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.List;

public class RunFile
extends FileParseUtilities {
    private BatchFitLibrary batchFitLibrary;
    private String encoding;
    private List<StoryTestListener> testListeners;

    public RunFile(String encoding, List<StoryTestListener> testListeners, BatchFitLibrary batchFitLibrary) {
        this.encoding = encoding;
        this.testListeners = testListeners;
        this.batchFitLibrary = batchFitLibrary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runFile(File file, File theReportDiry, Report report, Parse fullSetUpTables, Parse fullTearDownTables) {
        block7: {
            String name = file.getName();
            PrintStream oldOut = System.out;
            PrintStream oldErr = System.err;
            ByteArrayOutputStream tempOut = new ByteArrayOutputStream();
            ByteArrayOutputStream tempErr = new ByteArrayOutputStream();
            try {
                if (RunFile.isXlsFileName(name) || RunFile.isHtmlFileName(name)) {
                    System.setOut(new PrintStream(tempOut));
                    System.setErr(new PrintStream(tempErr));
                    File reportFile = new File(theReportDiry, RunFile.reportName(file));
                    if (RunFile.fileIsLocked(reportFile)) {
                        throw new RuntimeException("File is locked");
                    }
                    Parse setUp = RunFile.copyParse(fullSetUpTables.more);
                    Parse tearDown = RunFile.copyParse(fullTearDownTables);
                    Traverse.setContext(theReportDiry);
                    Counts counts = RunFile.isXlsFileName(name) ? new SpreadsheetRunner(report).run(file, reportFile, setUp, tearDown, this.batchFitLibrary) : new HtmlRunner(report).runInSuite(file, reportFile, this.encoding, setUp, tearDown, this.batchFitLibrary);
                    report.addAssertionCountsForPage(reportFile, counts);
                    break block7;
                }
                throw new RuntimeException("Not HTML nor XLS");
            }
            catch (Exception e) {
                RunFile.ignoreFile(file, e);
            }
            finally {
                this.reportOutput(name, "out", tempOut.toString());
                this.reportOutput(name, "err", tempErr.toString());
                System.setOut(oldOut);
                System.setErr(oldErr);
            }
        }
    }

    private void reportOutput(String name, String out, String message) {
        for (StoryTestListener listener : this.testListeners) {
            listener.reportOutput(name, out, message);
        }
    }
}

