/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runtime;

import fitlibrary.config.Configuration;
import fitlibrary.flow.GlobalActionScope;
import fitlibrary.flow.IScope;
import fitlibrary.log.FileLogger;
import fitlibrary.runResults.TestResults;
import fitlibrary.traverse.TableEvaluator;
import fitlibrary.typed.TypedObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SuiteWideRuntimeContext
implements Configuration {
    private Map<String, Integer> timeouts = new HashMap<String, Integer>();
    private FileLogger fileLogger = new FileLogger();
    private IScope scope;
    private TableEvaluator tableEvaluator;
    private GlobalActionScope global;
    private boolean keepUniCode = false;
    private boolean addTimings = false;
    private int maxErrorBeforeStopping = Integer.MAX_VALUE;
    private int maxFailsBeforeStopping = Integer.MAX_VALUE;

    public SuiteWideRuntimeContext(IScope scope, GlobalActionScope global) {
        this.scope = scope;
        this.global = global;
    }

    public void putTimeout(String name, int timeout) {
        this.timeouts.put(name, timeout);
    }

    public int getTimeout(String name, int defaultTimeout) {
        Integer timeout = this.timeouts.get(name);
        if (timeout == null) {
            return defaultTimeout;
        }
        return timeout;
    }

    public void reset() {
        this.timeouts = new HashMap<String, Integer>();
    }

    public void startLogging(String fileName) {
        this.fileLogger.start(fileName);
    }

    public void printToLog(String s) throws IOException {
        this.fileLogger.println(s);
    }

    public IScope getScope() {
        if (this.scope == null) {
            throw new RuntimeException("No scope in runtime");
        }
        return this.scope;
    }

    public void addNamedObject(String name, TypedObject typedObject) {
        this.scope.addNamedObject(name, typedObject);
    }

    public void setAbandon(boolean abandon) {
        this.scope.setAbandon(abandon);
    }

    public boolean isAbandoned(TestResults testResults) {
        return this.scope.isAbandon() || this.scope.isStopOnError() && testResults.problems() || testResults.getCounts().exceptions >= this.maxErrorBeforeStopping || testResults.getCounts().wrong >= this.maxFailsBeforeStopping;
    }

    public void setStopOnError(boolean stop) {
        this.scope.setStopOnError(stop);
    }

    public void stopAfterErrorsOrFails(int maxErrors, int maxFails) {
        this.maxErrorBeforeStopping = maxErrors;
        this.maxFailsBeforeStopping = maxFails;
    }

    public void setTableEvaluator(TableEvaluator evaluator) {
        this.tableEvaluator = evaluator;
    }

    public TableEvaluator getTableEvaluator() {
        return this.tableEvaluator;
    }

    public GlobalActionScope getGlobal() {
        return this.global;
    }

    @Override
    public boolean keepingUniCode() {
        return this.keepUniCode;
    }

    public void keepUnicode(boolean keep) {
        this.keepUniCode = keep;
    }

    @Override
    public boolean isAddTimings() {
        return this.addTimings;
    }

    @Override
    public void addTimings(boolean add) {
        this.addTimings = add;
    }
}

