/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.selenium;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class HtmlSeleniumStream {
    protected PrintWriter writer;
    private boolean inTable = false;
    private int maxColumns = 3;

    public HtmlSeleniumStream(Writer writer) {
        this.writer = new PrintWriter(writer);
        this.writer.println("<html><head><title>Generated from FitNesse</title></head><body>");
    }

    public HtmlSeleniumStream(FileWriter writer, int maxColumns) {
        this(writer);
        this.maxColumns = maxColumns;
    }

    public void printHeader1(String s) {
        this.endTable();
        this.writer.println("<h1>" + s + "</h1>");
    }

    public void printHeader2(String s) {
        this.endTable();
        this.writer.println("<h2>" + s + "</h2>");
    }

    public void printHeader3(String s) {
        this.endTable();
        this.writer.println("<h3>" + s + "</h3>");
    }

    public void close() {
        this.endTable();
        this.writer.println("</body></html>");
        this.writer.close();
    }

    protected void printRow(String command) {
        this.startTable();
        if (this.maxColumns > 1) {
            this.writer.println("<tr><td>" + command + "</td><td></td><td></td></tr>");
        } else {
            this.writer.println("<tr><td>" + command + "</td></tr>");
        }
    }

    protected void printRow(String command, String target) {
        this.startTable();
        this.writer.println("<tr><td>" + command + "</td><td>" + target + "</td><td></td></tr>");
    }

    protected void printRow(String command, String target, String value) {
        this.startTable();
        this.writer.println("<tr><td>" + command + "</td><td>" + target + "</td><td>" + value + "</td></tr>");
    }

    private void startTable() {
        if (!this.inTable) {
            this.inTable = true;
            this.writer.println("<table border=2 cellspacing=0><tbody>");
            if (this.maxColumns > 1) {
                this.writer.println("<tr><td><i>" + this.getTableHeader() + "</i></td><td></td><td></td></tr>");
            } else {
                this.writer.println("<tr><td><i>" + this.getTableHeader() + "</i></td></tr>");
            }
        }
    }

    protected String getTableHeader() {
        return "Fit";
    }

    private void endTable() {
        if (this.inTable) {
            this.writer.println("</tbody></table>");
        }
        this.inTable = false;
    }
}

