/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fit.Parse;
import fitlibrary.exception.table.MissingRowException;
import fitlibrary.runResults.ITableListener;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableConversion;
import fitlibrary.table.TableElementOnList;
import fitlibrary.table.TableFactory;
import fitlibrary.tableOnParse.TablesOnParse;

public class TableOnList
extends TableElementOnList<Table, Row>
implements Table {
    private int firstErrorRow = 0;

    public TableOnList() {
        super("table");
        this.addToTag(" border=\"1\" cellspacing=\"0\"");
    }

    public TableOnList(Row ... rows) {
        this();
        for (Row row : rows) {
            ((TableElementOnList)this).add(row);
        }
    }

    @Override
    public Row at(int i) {
        if (!this.atExists(i)) {
            throw new MissingRowException("");
        }
        return (Row)super.at(i);
    }

    @Override
    public void pass(TestResults testResults) {
        this.at(this.firstErrorRow).pass(testResults);
    }

    @Override
    public void ignore(TestResults testResults) {
        this.at(this.firstErrorRow).ignore(testResults);
    }

    @Override
    public void error(TestResults testResults, Throwable e) {
        this.at(this.firstErrorRow).error(testResults, e);
    }

    @Override
    public void error(ITableListener tableListener, Throwable e) {
        this.error(tableListener.getTestResults(), e);
    }

    @Override
    public Row newRow() {
        Row row = TableFactory.row();
        ((TableElementOnList)this).add(row);
        return row;
    }

    @Override
    public int phaseBoundaryCount() {
        int count = this.getLeader().split("<hr>").length - 1;
        if (count == 0) {
            count = this.getLeader().split("<hr/>").length - 1;
        }
        return count;
    }

    @Override
    public void addFoldingText(String fold) {
        this.addToTrailer(fold);
    }

    public TablesOnParse getTables() {
        TablesOnParse tables = new TablesOnParse();
        tables.add(this);
        return tables;
    }

    @Override
    public void evenUpRows() {
        int maxRowLength = this.getMaxRowColumnSpan();
        for (Row row : this) {
            row.setColumnSpan(maxRowLength);
        }
    }

    private int getMaxRowColumnSpan() {
        int maxLength = 0;
        for (Row row : this) {
            maxLength = Math.max(maxLength, row.getColumnSpan());
        }
        return maxLength;
    }

    @Override
    public boolean isPlainTextTable() {
        return this.getTagLine().contains("plain_text_table");
    }

    @Override
    public void replaceAt(int t, Row row) {
        if (t < this.size()) {
            this.removeElementAt(t);
        }
        this.add(t, row);
    }

    @Override
    public Table deepCopy() {
        Table copy = TableFactory.table();
        for (Row row : this) {
            copy.add(row.deepCopy());
        }
        copy.setLeader(this.getLeader());
        copy.setTrailer(this.getTrailer());
        copy.setTagLine(this.getTagLine());
        return copy;
    }

    @Override
    public String getType() {
        return "Table";
    }

    @Override
    protected Table newObject() {
        return new TableOnList();
    }

    @Override
    public boolean hasRowsAfter(Row currentRow) {
        for (int i = 0; i < this.size() - 1; ++i) {
            if (this.at(i) != currentRow) continue;
            return true;
        }
        return false;
    }

    @Override
    public Parse asParse() {
        return this.asTableOnParse().asParse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table asTableOnParse() {
        TableFactory.useOnLists(false);
        try {
            Table table = TableConversion.convert(this);
            return table;
        }
        finally {
            TableFactory.pop();
        }
    }
}

