/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fitlibrary.table.Cell;
import fitlibrary.table.CellOnList;
import fitlibrary.table.Row;
import fitlibrary.table.RowOnList;
import fitlibrary.table.Table;
import fitlibrary.table.TableConversion;
import fitlibrary.table.TableFactory;
import fitlibrary.table.TableOnList;
import fitlibrary.table.Tables;
import fitlibrary.table.TablesOnList;
import fitlibrary.tableOnParse.CellOnParse;
import fitlibrary.tableOnParse.RowOnParse;
import fitlibrary.tableOnParse.TableOnParse;
import fitlibrary.tableOnParse.TablesOnParse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class TestParseToTableOnList {
    @Test
    public void setTagLineOnCellOnParse() {
        TableFactory.useOnLists(false);
        Cell cell = TableFactory.cell("ab");
        TableFactory.pop();
        MatcherAssert.assertThat((Object)cell, (Matcher)CoreMatchers.instanceOf(CellOnParse.class));
        MatcherAssert.assertThat((Object)cell.toString(), (Matcher)CoreMatchers.is((Object)"\n<td>ab</td>"));
        MatcherAssert.assertThat((Object)cell.getLeader(), (Matcher)CoreMatchers.is((Object)"\n"));
        MatcherAssert.assertThat((Object)cell.getTrailer(), (Matcher)CoreMatchers.is((Object)""));
        cell.setTagLine("extra");
        MatcherAssert.assertThat((Object)cell.getTagLine(), (Matcher)CoreMatchers.is((Object)"extra"));
        MatcherAssert.assertThat((Object)cell.toString(), (Matcher)CoreMatchers.is((Object)"\n<td extra>ab</td>"));
    }

    @Test
    public void setTagLineOnCellOnList() {
        TableFactory.useOnLists(true);
        Cell cell = TableFactory.cell("ab");
        TableFactory.pop();
        MatcherAssert.assertThat((Object)cell, (Matcher)CoreMatchers.instanceOf(CellOnList.class));
        MatcherAssert.assertThat((Object)cell.toString(), (Matcher)CoreMatchers.is((Object)"<td>ab</td>"));
        MatcherAssert.assertThat((Object)cell.getLeader(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)cell.getTrailer(), (Matcher)CoreMatchers.is((Object)""));
        cell.setTagLine("extra");
        MatcherAssert.assertThat((Object)cell.getTagLine(), (Matcher)CoreMatchers.is((Object)"extra"));
        MatcherAssert.assertThat((Object)cell.toString(), (Matcher)CoreMatchers.is((Object)"<td extra>ab</td>"));
    }

    @Test
    public void convertCellToListForm() {
        TableFactory.useOnLists(false);
        Cell cell = TableFactory.cell("ab");
        TableFactory.pop();
        MatcherAssert.assertThat((Object)cell, (Matcher)CoreMatchers.instanceOf(CellOnParse.class));
        cell.addToTag("extra");
        cell.addToTag("cost");
        MatcherAssert.assertThat((Object)cell.getTagLine(), (Matcher)CoreMatchers.is((Object)"extra cost"));
        MatcherAssert.assertThat((Object)cell.toString(), (Matcher)CoreMatchers.is((Object)"\n<td extra cost>ab</td>"));
        MatcherAssert.assertThat((Object)cell.getLeader(), (Matcher)CoreMatchers.is((Object)"\n"));
        MatcherAssert.assertThat((Object)cell.getTrailer(), (Matcher)CoreMatchers.is((Object)""));
        TableFactory.useOnLists(true);
        Cell cell2 = TableConversion.convert(cell);
        TableFactory.pop();
        MatcherAssert.assertThat((Object)cell2, (Matcher)CoreMatchers.instanceOf(CellOnList.class));
        MatcherAssert.assertThat((Object)cell2.getTagLine(), (Matcher)CoreMatchers.is((Object)"extra cost"));
        MatcherAssert.assertThat((Object)cell2.toString(), (Matcher)CoreMatchers.is((Object)"\n<td extra cost>ab</td>"));
        MatcherAssert.assertThat((Object)cell.getLeader(), (Matcher)CoreMatchers.is((Object)"\n"));
        MatcherAssert.assertThat((Object)cell.getTrailer(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void convertCellFromListForm() {
        TableFactory.useOnLists(true);
        Cell cell = TableFactory.cell("ab");
        TableFactory.pop();
        MatcherAssert.assertThat((Object)cell, (Matcher)CoreMatchers.instanceOf(CellOnList.class));
        cell.addToTag("extra");
        cell.addToTag("cost");
        MatcherAssert.assertThat((Object)cell.getTagLine(), (Matcher)CoreMatchers.is((Object)"extra cost"));
        MatcherAssert.assertThat((Object)cell.toString(), (Matcher)CoreMatchers.is((Object)"<td extra cost>ab</td>"));
        TableFactory.useOnLists(false);
        Cell cell2 = TableConversion.convert(cell);
        TableFactory.pop();
        MatcherAssert.assertThat((Object)cell2, (Matcher)CoreMatchers.instanceOf(CellOnParse.class));
        MatcherAssert.assertThat((Object)cell2.getTagLine(), (Matcher)CoreMatchers.is((Object)"extra cost"));
        MatcherAssert.assertThat((Object)cell2.toString(), (Matcher)CoreMatchers.is((Object)"<td extra cost>ab</td>"));
    }

    @Test
    public void convertTableToListForm() {
        TableFactory.useOnLists(false);
        Table table = TableFactory.table();
        TableFactory.pop();
        MatcherAssert.assertThat((Object)table, (Matcher)CoreMatchers.instanceOf(TableOnParse.class));
        table.addToTag("extra");
        table.addToTag("cost");
        MatcherAssert.assertThat((Object)table.getTagLine(), (Matcher)CoreMatchers.is((Object)"border=\"1\" cellspacing=\"0\" extra cost"));
        MatcherAssert.assertThat((Object)table.toString(), (Matcher)CoreMatchers.is((Object)"\n<table border=\"1\" cellspacing=\"0\" extra cost></table>"));
        TableFactory.useOnLists(true);
        Table table2 = TableConversion.convert(table);
        TableFactory.pop();
        MatcherAssert.assertThat((Object)table2, (Matcher)CoreMatchers.instanceOf(TableOnList.class));
        MatcherAssert.assertThat((Object)table2.getTagLine(), (Matcher)CoreMatchers.is((Object)"border=\"1\" cellspacing=\"0\" extra cost"));
        MatcherAssert.assertThat((Object)table2.toString(), (Matcher)CoreMatchers.is((Object)"\n<table border=\"1\" cellspacing=\"0\" extra cost></table>"));
    }

    @Test
    public void convertTableFromListForm() {
        TableFactory.useOnLists(true);
        Table table = TableFactory.table();
        TableFactory.pop();
        MatcherAssert.assertThat((Object)table, (Matcher)CoreMatchers.instanceOf(TableOnList.class));
        table.addToTag("extra");
        table.addToTag("cost");
        MatcherAssert.assertThat((Object)table.getTagLine(), (Matcher)CoreMatchers.is((Object)"border=\"1\" cellspacing=\"0\" extra cost"));
        MatcherAssert.assertThat((Object)table.toString(), (Matcher)CoreMatchers.is((Object)"<table border=\"1\" cellspacing=\"0\" extra cost></table>"));
        TableFactory.useOnLists(false);
        Table table2 = TableConversion.convert(table);
        TableFactory.pop();
        MatcherAssert.assertThat((Object)table2, (Matcher)CoreMatchers.instanceOf(TableOnParse.class));
        MatcherAssert.assertThat((Object)table2.getTagLine(), (Matcher)CoreMatchers.is((Object)"border=\"1\" cellspacing=\"0\" extra cost"));
        MatcherAssert.assertThat((Object)table2.toString(), (Matcher)CoreMatchers.is((Object)"<table border=\"1\" cellspacing=\"0\" extra cost></table>"));
    }

    @Test
    public void convertTablesToListForm() {
        TableFactory.useOnLists(false);
        Tables tables = TableFactory.tables(TableFactory.table(TableFactory.row("a", "b")));
        TableFactory.pop();
        MatcherAssert.assertThat((Object)tables, (Matcher)CoreMatchers.instanceOf(TablesOnParse.class));
        ((Table)tables.at(0)).setLeader("LL");
        ((Table)tables.at(0)).setTrailer("TT");
        ((Table)tables.at(0)).addToTag("RR");
        ((Row)((Table)tables.at(0)).at(0)).setLeader("00LL");
        ((Row)((Table)tables.at(0)).at(0)).setTrailer("00TT");
        ((Cell)((Row)((Table)tables.at(0)).at(0)).at(0)).addToTag(" 00RR");
        TableFactory.useOnLists(true);
        Tables tables2 = TableConversion.convert(tables);
        TableFactory.pop();
        MatcherAssert.assertThat((Object)tables2, (Matcher)CoreMatchers.instanceOf(TablesOnList.class));
        Table table = (Table)tables2.at(0);
        MatcherAssert.assertThat((Object)table, (Matcher)CoreMatchers.instanceOf(TableOnList.class));
        MatcherAssert.assertThat((Object)table.getLeader(), (Matcher)CoreMatchers.is((Object)"LL"));
        MatcherAssert.assertThat((Object)table.getTrailer(), (Matcher)CoreMatchers.is((Object)"TT"));
        MatcherAssert.assertThat((Object)table.getTagLine(), (Matcher)CoreMatchers.is((Object)"border=\"1\" cellspacing=\"0\" RR"));
        MatcherAssert.assertThat((Object)tables2.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)table.size(), (Matcher)CoreMatchers.is((Object)1));
        Row row = (Row)table.at(0);
        MatcherAssert.assertThat((Object)row, (Matcher)CoreMatchers.instanceOf(RowOnList.class));
        MatcherAssert.assertThat((Object)row.getLeader(), (Matcher)CoreMatchers.is((Object)"00LL"));
        MatcherAssert.assertThat((Object)row.getTrailer(), (Matcher)CoreMatchers.is((Object)"00TT"));
        MatcherAssert.assertThat((Object)row.size(), (Matcher)CoreMatchers.is((Object)2));
        Cell cell = (Cell)row.at(0);
        MatcherAssert.assertThat((Object)cell, (Matcher)CoreMatchers.instanceOf(CellOnList.class));
        MatcherAssert.assertThat((Object)cell.getTagLine(), (Matcher)CoreMatchers.is((Object)"00RR"));
        MatcherAssert.assertThat((Object)cell.text(), (Matcher)CoreMatchers.is((Object)"a"));
        MatcherAssert.assertThat((Object)((Cell)row.at(1)).text(), (Matcher)CoreMatchers.is((Object)"b"));
    }

    @Test
    public void convertToParseForm() {
        TableFactory.useOnLists(true);
        Tables tables = TableFactory.tables(TableFactory.table(TableFactory.row("a", "b")));
        MatcherAssert.assertThat((Object)tables, (Matcher)CoreMatchers.instanceOf(TablesOnList.class));
        TableFactory.pop();
        ((Table)tables.at(0)).setLeader("LL");
        ((Table)tables.at(0)).setTrailer("TT");
        ((Table)tables.at(0)).addToTag("RR");
        ((Row)((Table)tables.at(0)).at(0)).setLeader("00LL");
        ((Row)((Table)tables.at(0)).at(0)).setTrailer("00TT");
        ((Cell)((Row)((Table)tables.at(0)).at(0)).at(0)).addToTag(" 00RR");
        TableFactory.useOnLists(false);
        Tables tables2 = TableConversion.convert(tables);
        TableFactory.pop();
        MatcherAssert.assertThat((Object)tables2, (Matcher)CoreMatchers.instanceOf(TablesOnParse.class));
        Table table = (Table)tables2.at(0);
        MatcherAssert.assertThat((Object)table, (Matcher)CoreMatchers.instanceOf(TableOnParse.class));
        MatcherAssert.assertThat((Object)table.getLeader(), (Matcher)CoreMatchers.is((Object)"LL"));
        MatcherAssert.assertThat((Object)table.getTrailer(), (Matcher)CoreMatchers.is((Object)"TT"));
        MatcherAssert.assertThat((Object)table.getTagLine(), (Matcher)CoreMatchers.is((Object)"border=\"1\" cellspacing=\"0\" RR"));
        MatcherAssert.assertThat((Object)tables2.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)table.size(), (Matcher)CoreMatchers.is((Object)1));
        Row row = (Row)table.at(0);
        MatcherAssert.assertThat((Object)row, (Matcher)CoreMatchers.instanceOf(RowOnParse.class));
        MatcherAssert.assertThat((Object)row.getLeader(), (Matcher)CoreMatchers.is((Object)"00LL"));
        MatcherAssert.assertThat((Object)row.getTrailer(), (Matcher)CoreMatchers.is((Object)"00TT"));
        MatcherAssert.assertThat((Object)row.size(), (Matcher)CoreMatchers.is((Object)2));
        Cell cell = (Cell)row.at(0);
        MatcherAssert.assertThat((Object)cell, (Matcher)CoreMatchers.instanceOf(CellOnParse.class));
        MatcherAssert.assertThat((Object)cell.getTagLine(), (Matcher)CoreMatchers.is((Object)"00RR"));
        MatcherAssert.assertThat((Object)cell.text(), (Matcher)CoreMatchers.is((Object)"a"));
        MatcherAssert.assertThat((Object)((Cell)row.at(1)).text(), (Matcher)CoreMatchers.is((Object)"b"));
    }
}

