/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fitlibrary.runtime.RuntimeContextContainer;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.Cell;
import fitlibrary.table.CellOnList;
import fitlibrary.table.Row;
import fitlibrary.table.RowOnList;
import fitlibrary.table.Table;
import fitlibrary.table.TableOnList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class TestRowOnList {
    RuntimeContextInternal runtime = new RuntimeContextContainer();
    Row row = TestRowOnList.row();

    @Test
    public void sizeOfEmptyRow() {
        MatcherAssert.assertThat((Object)this.row.size(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.row.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void columnSpanWithNoCellsIsZero() throws Exception {
        MatcherAssert.assertThat((Object)this.row.getColumnSpan(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void columnSpanWithOneCellWithNoColumnSpanSetIsOne() throws Exception {
        this.row.addCell("1");
        MatcherAssert.assertThat((Object)this.row.getColumnSpan(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void columnSpanWithOneCellWithColumnSpanSet() throws Exception {
        this.row.addCell("1", 4);
        MatcherAssert.assertThat((Object)this.row.getColumnSpan(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void columnSpanWithMultipleCellsWithAndWithoutColumnSpanSet() throws Exception {
        this.row.addCell("1", 4);
        this.row.addCell("2");
        this.row.addCell("3", 2);
        this.row.addCell("4");
        MatcherAssert.assertThat((Object)this.row.getColumnSpan(), (Matcher)CoreMatchers.is((Object)8));
    }

    @Test
    public void setColumnSpanWithNoCellsHadsOneCell() {
        this.row.setColumnSpan(4);
        MatcherAssert.assertThat((Object)this.row.getColumnSpan(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)((Cell)this.row.at(0)).getColumnSpan(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void setColumnSpanWithOneCellWithNoColumnSpanSet() {
        this.row.addCell("1");
        this.row.setColumnSpan(4);
        MatcherAssert.assertThat((Object)this.row.getColumnSpan(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)((Cell)this.row.at(0)).getColumnSpan(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void setColumnSpanWithOneCellWithColumnSpanSet() {
        this.row.addCell("1", 3);
        this.row.setColumnSpan(4);
        MatcherAssert.assertThat((Object)this.row.getColumnSpan(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)((Cell)this.row.at(0)).getColumnSpan(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void setColumnSpanWithMultipleCellsWithAndWithoutColumnSpanSetAddToTheColumnSpanOfLastCell() throws Exception {
        this.row.addCell("1", 4);
        this.row.addCell("2");
        this.row.addCell("3", 2);
        this.row.addCell("4", 4);
        this.row.setColumnSpan(15);
        MatcherAssert.assertThat((Object)this.row.getColumnSpan(), (Matcher)CoreMatchers.is((Object)15));
        MatcherAssert.assertThat((Object)((Cell)this.row.at(0)).getColumnSpan(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)((Cell)this.row.at(1)).getColumnSpan(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Cell)this.row.at(2)).getColumnSpan(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((Cell)this.row.at(3)).getColumnSpan(), (Matcher)CoreMatchers.is((Object)8));
    }

    @Test
    public void plainMethodNameNoArg() {
        Row row = TestRowOnList.row("aa");
        MatcherAssert.assertThat((Object)row.methodNameForPlain(this.runtime), (Matcher)CoreMatchers.is((Object)"aa"));
        MatcherAssert.assertThat((Object)row.methodNameForCamel(this.runtime), (Matcher)CoreMatchers.is((Object)"aa"));
    }

    @Test
    public void plainMethodNameOneArg() {
        Row row = TestRowOnList.row("aa", "1");
        MatcherAssert.assertThat((Object)row.methodNameForPlain(this.runtime), (Matcher)CoreMatchers.is((Object)"aa|"));
        MatcherAssert.assertThat((Object)row.methodNameForCamel(this.runtime), (Matcher)CoreMatchers.is((Object)"aa"));
    }

    @Test
    public void plainMethodNameOneArgTwoKeywords() {
        Row row = TestRowOnList.row("aa", "1", "bb");
        MatcherAssert.assertThat((Object)row.methodNameForPlain(this.runtime), (Matcher)CoreMatchers.is((Object)"aa|bb"));
        MatcherAssert.assertThat((Object)row.methodNameForCamel(this.runtime), (Matcher)CoreMatchers.is((Object)"aaBb"));
    }

    @Test
    public void plainMethodNameTwoArgs() {
        Row row = TestRowOnList.row("aa", "1", "bb", "2");
        MatcherAssert.assertThat((Object)row.methodNameForPlain(this.runtime), (Matcher)CoreMatchers.is((Object)"aa|bb|"));
        MatcherAssert.assertThat((Object)row.methodNameForCamel(this.runtime), (Matcher)CoreMatchers.is((Object)"aaBb"));
    }

    @Test
    public void plainMethodNameTwoArgsThreeKeywords() {
        Row row = TestRowOnList.row("aa", "1", "bb", "2", ".");
        MatcherAssert.assertThat((Object)row.methodNameForPlain(this.runtime), (Matcher)CoreMatchers.is((Object)"aa|bb|."));
        MatcherAssert.assertThat((Object)row.methodNameForCamel(this.runtime), (Matcher)CoreMatchers.is((Object)"aaBbDot"));
    }

    @Test
    public void canReplaceRowAtStart() {
        Row row = TestRowOnList.row("a", "b");
        Row row2 = TestRowOnList.row("x", "y");
        Row row3 = TestRowOnList.row("m", "n");
        Table table = TestRowOnList.table();
        table.add(row);
        table.add(row2);
        MatcherAssert.assertThat(table.at(0), (Matcher)CoreMatchers.is((Object)row));
        MatcherAssert.assertThat(table.at(1), (Matcher)CoreMatchers.is((Object)row2));
        table.replaceAt(0, row3);
        MatcherAssert.assertThat(table.at(0), (Matcher)CoreMatchers.is((Object)row3));
        MatcherAssert.assertThat(table.at(1), (Matcher)CoreMatchers.is((Object)row2));
    }

    @Test
    public void canReplaceRowAtEnd() {
        Row row = TestRowOnList.row("a", "b");
        Row row2 = TestRowOnList.row("x", "y");
        Row row3 = TestRowOnList.row("m", "n");
        Table table = TestRowOnList.table();
        table.add(row);
        table.add(row2);
        table.replaceAt(1, row3);
        MatcherAssert.assertThat(table.at(0), (Matcher)CoreMatchers.is((Object)row));
        MatcherAssert.assertThat(table.at(1), (Matcher)CoreMatchers.is((Object)row3));
    }

    @Test
    public void elementsFrom0() {
        Row row = TestRowOnList.row("a", "b", "c");
        Row row2 = (Row)row.fromAt(0);
        MatcherAssert.assertThat((Object)row2.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat(row2.at(0), (Matcher)CoreMatchers.is(row.at(0)));
        MatcherAssert.assertThat(row2.at(1), (Matcher)CoreMatchers.is(row.at(1)));
        MatcherAssert.assertThat(row2.at(2), (Matcher)CoreMatchers.is(row.at(2)));
    }

    @Test
    public void elementsFrom2() {
        Row row = TestRowOnList.row("a", "b", "c");
        Row row2 = (Row)row.fromAt(2);
        MatcherAssert.assertThat((Object)row2.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(row2.at(0), (Matcher)CoreMatchers.is(row.at(2)));
    }

    @Test
    public void elementsFromTo() {
        Row row = TestRowOnList.row("a", "b", "c");
        Row row2 = (Row)row.fromTo(1, 2);
        MatcherAssert.assertThat((Object)row2.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(row2.at(0), (Matcher)CoreMatchers.is(row.at(1)));
    }

    @Test
    public void last() {
        Row row = TestRowOnList.row("a", "b", "c");
        MatcherAssert.assertThat(row.last(), (Matcher)CoreMatchers.is(row.at(2)));
    }

    protected static Row row() {
        return new RowOnList();
    }

    protected static Row row(String ... stringArray) {
        Row row = TestRowOnList.row();
        for (String string : stringArray) {
            row.add(new CellOnList(string));
        }
        return row;
    }

    protected static Table table() {
        return new TableOnList();
    }
}

