/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.matcher.TableBuilderForTests;
import fitlibrary.runResults.TableListener;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.table.TableOnList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestTableOnList {
    Mockery context = new Mockery();
    TestResults testResults = (TestResults)this.context.mock(TestResults.class);
    VariableResolver resolver = (VariableResolver)this.context.mock(VariableResolver.class);
    Row row0 = (Row)TableBuilderForTests.row().mock(this.context, "", 0);
    Row row1 = (Row)TableBuilderForTests.row().mock(this.context, "", 1);
    Row row2 = (Row)TableBuilderForTests.row().mock(this.context, "", 2);
    Table table01 = TestTableOnList.table(this.row0, this.row1);
    Table table012 = TestTableOnList.table(this.row0, this.row1, this.row2);

    @Before
    public void useListsFactory() {
        TableFactory.useOnLists(true);
    }

    @After
    public void stopUsingListsFactory() {
        TableFactory.pop();
    }

    @Test
    public void pass() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.oneOf(TestTableOnList.this.row0)).pass(TestTableOnList.this.testResults);
            }
        });
        this.table01.pass(this.testResults);
    }

    @Test
    public void ignore() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.oneOf(TestTableOnList.this.row0)).ignore(TestTableOnList.this.testResults);
            }
        });
        this.table01.ignore(this.testResults);
    }

    @Test
    public void error() {
        final RuntimeException runtimeException = new RuntimeException();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.oneOf(TestTableOnList.this.row0)).error(TestTableOnList.this.testResults, runtimeException);
            }
        });
        this.table01.error(this.testResults, (Throwable)runtimeException);
    }

    @Test
    public void errorWithTableListener() {
        final RuntimeException runtimeException = new RuntimeException();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.oneOf(TestTableOnList.this.row0)).error(TestTableOnList.this.testResults, runtimeException);
            }
        });
        this.table01.error(new TableListener(this.testResults), (Throwable)runtimeException);
    }

    @Test
    public void newRow() {
        this.table01.newRow();
        MatcherAssert.assertThat((Object)this.table01.size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void phaseBoundaryCount() {
        this.table01.setLeader("12<hr/>34<hr/>456<hr/>");
        MatcherAssert.assertThat((Object)this.table01.phaseBoundaryCount(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void addFoldingText() {
        this.table01.addFoldingText("12");
        MatcherAssert.assertThat((Object)this.table01.getTrailer(), (Matcher)CoreMatchers.is((Object)"12"));
    }

    @Test
    public void replaceAt() {
        this.table01.replaceAt(0, this.row2);
        MatcherAssert.assertThat((Object)this.table01.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(this.table01.at(0), (Matcher)CoreMatchers.is((Object)this.row2));
        MatcherAssert.assertThat(this.table01.at(1), (Matcher)CoreMatchers.is((Object)this.row1));
    }

    @Test
    public void replaceAtAfter() {
        this.table01.replaceAt(2, this.row2);
        MatcherAssert.assertThat((Object)this.table01.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat(this.table01.at(0), (Matcher)CoreMatchers.is((Object)this.row0));
        MatcherAssert.assertThat(this.table01.at(1), (Matcher)CoreMatchers.is((Object)this.row1));
        MatcherAssert.assertThat(this.table01.at(2), (Matcher)CoreMatchers.is((Object)this.row2));
    }

    @Test
    public void fromAt0() {
        Table table = (Table)this.table012.fromAt(0);
        MatcherAssert.assertThat((Object)table.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat(table.at(0), (Matcher)CoreMatchers.is((Object)this.row0));
        MatcherAssert.assertThat(table.at(1), (Matcher)CoreMatchers.is((Object)this.row1));
        MatcherAssert.assertThat(table.at(2), (Matcher)CoreMatchers.is((Object)this.row2));
    }

    @Test
    public void fromAt1() {
        Table table = (Table)this.table012.fromAt(1);
        MatcherAssert.assertThat((Object)table.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(table.at(0), (Matcher)CoreMatchers.is((Object)this.row1));
        MatcherAssert.assertThat(table.at(1), (Matcher)CoreMatchers.is((Object)this.row2));
    }

    @Test
    public void fromAt2() {
        Table table = (Table)this.table012.fromAt(2);
        MatcherAssert.assertThat((Object)table.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(table.at(0), (Matcher)CoreMatchers.is((Object)this.row2));
    }

    @Test
    public void hasRowsAfter() {
        MatcherAssert.assertThat((Object)this.table01.hasRowsAfter(this.row0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.table01.hasRowsAfter(this.row1), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.table01.hasRowsAfter(this.row2), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void deepCopy() {
        final Row row = (Row)TableBuilderForTests.row().mock(this.context, "", 55);
        final Row row2 = (Row)TableBuilderForTests.row().mock(this.context, "", 66);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.oneOf(TestTableOnList.this.row0)).deepCopy();
                this.will(5.returnValue((Object)row));
                ((Row)this.oneOf(TestTableOnList.this.row1)).deepCopy();
                this.will(5.returnValue((Object)row2));
            }
        });
        this.table01.setLeader("LL");
        this.table01.setTrailer("TT");
        Table table = (Table)this.table01.deepCopy();
        MatcherAssert.assertThat((Object)table.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(table.at(0), (Matcher)CoreMatchers.is((Object)row));
        MatcherAssert.assertThat(table.at(1), (Matcher)CoreMatchers.is((Object)row2));
        MatcherAssert.assertThat((Object)table.getLeader(), (Matcher)CoreMatchers.is((Object)"LL"));
        MatcherAssert.assertThat((Object)table.getTrailer(), (Matcher)CoreMatchers.is((Object)"TT"));
    }

    @Test
    public void toHtml() {
        final StringBuilder stringBuilder = new StringBuilder();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.oneOf(TestTableOnList.this.row0)).toHtml(stringBuilder);
                ((Row)this.oneOf(TestTableOnList.this.row1)).toHtml(stringBuilder);
            }
        });
        this.table01.setLeader("LL");
        this.table01.setTrailer("TT");
        this.table01.toHtml(stringBuilder);
        MatcherAssert.assertThat((Object)stringBuilder.toString(), (Matcher)CoreMatchers.is((Object)"LL<table border=\"1\" cellspacing=\"0\"></table>TT"));
    }

    protected static Table table(Row ... rowArray) {
        TableOnList tableOnList = new TableOnList();
        for (Row row : rowArray) {
            tableOnList.add(row);
        }
        return tableOnList;
    }
}

