/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.tableOnParse;

import fit.Parse;
import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.exception.FitLibraryShowException;
import fitlibrary.exception.table.MissingCellsException;
import fitlibrary.global.PlugBoard;
import fitlibrary.runResults.TestResults;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.TableFactory;
import fitlibrary.tableOnParse.CellOnParse;
import fitlibrary.tableOnParse.TableElementOnParse;
import java.util.ArrayList;
import java.util.Iterator;

public class RowOnParse
extends TableElementOnParse<Cell>
implements Row {
    private boolean rowIsHidden = false;

    public RowOnParse(Parse parse) {
        super(parse);
    }

    public RowOnParse() {
        this(new Parse("tr", "", null, null));
    }

    @Override
    public int size() {
        if (this.parse.parts == null) {
            return 0;
        }
        return this.parse.parts.size();
    }

    @Override
    public Cell at(int i) {
        if (!this.atExists(i)) {
            throw new MissingCellsException("");
        }
        return new CellOnParse(this.parse.parts.at(i));
    }

    @Override
    public void pass(TestResults testResults) {
        if (this.rowIsHidden) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.pass(testResults);
    }

    @Override
    public void fail(TestResults testResults) {
        if (this.rowIsHidden) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.fail(testResults);
    }

    @Override
    public void error(TestResults testResults, Throwable throwable) {
        Throwable e = PlugBoard.exceptionHandling.unwrapThrowable(throwable);
        if (e instanceof FitLibraryShowException) {
            this.handleShow((FitLibraryShowException)e);
        } else {
            this.at(0).error(testResults, e);
        }
    }

    private void handleShow(FitLibraryShowException exception) {
        Cell cell = this.addCell();
        cell.setText(exception.getResult().getHtmlString());
        cell.shown();
    }

    @Override
    public String text(int i, VariableResolver resolver) {
        return this.at(i).text(resolver);
    }

    @Override
    public void missing(TestResults testResults) {
        this.at(0).expectedElementMissing(testResults);
    }

    @Override
    public Cell addCell() {
        Cell cell = TableFactory.cell("");
        this.add(cell);
        return cell;
    }

    @Override
    public RowOnParse add(Cell cell) {
        if (this.rowIsHidden) {
            System.out.println("Bug: Adding a cell to a hidden row in a table");
        }
        if (this.parse.parts == null) {
            this.parse.parts = cell.parse();
        } else {
            this.parse.parts.last().more = cell.parse();
        }
        return this;
    }

    @Override
    public Cell addCell(String text) {
        Cell cell = TableFactory.cell(text);
        this.add(cell);
        return cell;
    }

    @Override
    public Cell addCell(String text, int cols) {
        CellOnParse cell = new CellOnParse(text);
        cell.setColumnSpan(cols);
        this.add(cell);
        return cell;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RowOnParse)) {
            return false;
        }
        RowOnParse other = (RowOnParse)object;
        if (other.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.at(i).equals(other.at(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ignore(TestResults testResults) {
        for (int i = 0; i < this.size(); ++i) {
            this.at(i).ignore(testResults);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void setIsHidden() {
        this.rowIsHidden = true;
        for (int i = 0; i < this.size(); ++i) {
            this.at(i).setIsHidden();
        }
    }

    public Cell lastCell() {
        return this.at(this.size() - 1);
    }

    public void addCommentRow(Cell cell) {
        RowOnParse commentRow = new RowOnParse();
        commentRow.addCell("note");
        commentRow.add(cell);
        Parse next = this.parse.more;
        this.parse.more = commentRow.parse;
        commentRow.parse.more = next;
    }

    @Override
    public Row fromAt(int rowNo) {
        return TableFactory.row(this.at(rowNo));
    }

    @Override
    public Row fromTo(int from, int upto) {
        Row row = TableFactory.row();
        for (int i = from; i < upto; ++i) {
            row.add(TableFactory.cell(this.at(i)));
        }
        return row;
    }

    @Override
    public void passKeywords(TestResults testResults) {
        for (int i = 0; i < this.size(); i += 2) {
            this.at(i).pass(testResults);
        }
    }

    @Override
    public Row deepCopy() {
        Row rowCopy = TableFactory.row();
        for (int i = 0; i < this.size(); ++i) {
            rowCopy.add(TableFactory.cell(this.at(i).fullText()));
        }
        return rowCopy;
    }

    @Override
    public void clear() {
        this.parse.parts = null;
    }

    @Override
    public String methodNameForPlain(RuntimeContextInternal runtime) {
        String name = "";
        for (int i = 0; i < this.size(); i += 2) {
            name = name + this.text(i, runtime);
            if (i + 1 >= this.size()) continue;
            name = name + "|";
        }
        return name;
    }

    @Override
    public String methodNameForCamel(RuntimeContextInternal runtime) {
        String name = "";
        for (int i = 0; i < this.size(); i += 2) {
            name = name + this.text(i, runtime) + " ";
        }
        return runtime.extendedCamel(name.trim());
    }

    @Override
    public int argumentCount() {
        return this.size() / 2;
    }

    public boolean hasFurtherRows() {
        return this.parse.more != null;
    }

    @Override
    public int getColumnSpan() {
        int col = 0;
        for (int i = 0; i < this.size(); ++i) {
            col += this.at(i).getColumnSpan();
        }
        return col;
    }

    @Override
    public void setColumnSpan(int span) {
        if (this.isEmpty()) {
            this.addCell();
        }
        this.lastCell().setColumnSpan(span - this.getColumnSpan() + this.lastCell().getColumnSpan());
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void removeElementAt(int i) {
        if (i == 0) {
            this.parse.parts = this.parse.parts.more;
        } else {
            this.at((int)(i - 1)).parse().more = null;
            this.at((int)(i - 1)).parse().trailer = "";
        }
    }

    @Override
    public Iterator<Cell> iterator() {
        ArrayList<Cell> list = new ArrayList<Cell>();
        for (int i = 0; i < this.size(); ++i) {
            list.add(this.at(i));
        }
        return list.iterator();
    }

    @Override
    public String getType() {
        return "Row";
    }
}

