/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.tableOnParse;

import fit.Parse;
import fitlibrary.runResults.TestResults;
import fitlibrary.tableOnParse.TablesOnParse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class TableElementOnParse<To> {
    public static final String PASS = " class=\"pass\"";
    public static final String FAIL = " class=\"fail\"";
    public static final String IGNORE = " class=\"ignore\"";
    public static final String ERROR = " class=\"error\"";
    public static final String SHOWN = " bgcolor=#C0C0FF";
    public static final String CALLS = " bgcolor=#DADAFF";
    protected Parse parse;

    public TableElementOnParse(Parse parse) {
        this.parse = parse;
    }

    public Parse parse() {
        return this.parse;
    }

    public Parse asParse() {
        return this.parse;
    }

    public void pass(TestResults testResults) {
        this.ensureBodyNotNull();
        this.parse.addToTag(PASS);
        testResults.pass();
    }

    public void fail(TestResults testResults) {
        this.ensureBodyNotNull();
        if (!this.hadError()) {
            this.parse.addToTag(FAIL);
            testResults.fail();
        }
    }

    public void passOrFail(TestResults testResults, boolean right) {
        if (right) {
            this.pass(testResults);
        } else {
            this.fail(testResults);
        }
    }

    public void shown() {
        this.ensureBodyNotNull();
        this.parse.addToTag(SHOWN);
    }

    public void calls() {
        this.ensureBodyNotNull();
        this.parse.addToTag(CALLS);
    }

    public static String label(String string) {
        return " <span class=\"fit_label\">" + string + "</span>";
    }

    public boolean didPass() {
        return this.tagContains(PASS);
    }

    public boolean didFail() {
        return this.tagContains(FAIL);
    }

    public boolean wasIgnored() {
        return this.tagContains(IGNORE);
    }

    public boolean hadError() {
        return this.tagContains(ERROR);
    }

    protected void ensureBodyNotNull() {
        if (this.parse.body == null) {
            this.parse.body = "";
        }
    }

    private boolean tagContains(String label) {
        return this.parse.tag.indexOf(label) >= 0;
    }

    public String getLeader() {
        if (this.parse == null) {
            return "";
        }
        String leader = this.parse.leader;
        if (leader == null) {
            return "";
        }
        return leader;
    }

    public String getTrailer() {
        if (this.parse == null) {
            return "";
        }
        String trailer = this.parse.trailer;
        if (trailer == null) {
            return "";
        }
        return trailer;
    }

    protected void addToTrailer(String s) {
        if (this.parse.trailer == null) {
            this.parse.trailer = "";
        }
        this.parse.trailer = s + this.parse.trailer;
    }

    protected void addToStartOfLeader(String s) {
        this.parse.leader = s + this.parse.leader;
    }

    public void setLeader(String leader) {
        this.parse.leader = leader;
    }

    public void setTrailer(String trailer) {
        this.parse.trailer = trailer;
    }

    public boolean atExists(int i) {
        return i >= 0 && i < this.size();
    }

    public To last() {
        return this.at(this.size() - 1);
    }

    public List<To> iterableFrom(int start) {
        ArrayList<To> list = new ArrayList<To>();
        for (int i = start; i < this.size(); ++i) {
            list.add(this.at(i));
        }
        return list;
    }

    public Iterator<To> iterator() {
        return this.iterableFrom(0).iterator();
    }

    public String getTagLine() {
        if (this.parse == null) {
            return "";
        }
        String tagLine = this.parse.tag;
        int index = tagLine.indexOf(" ");
        if (index < 0) {
            return "";
        }
        return tagLine.substring(index + 1, tagLine.length() - 1);
    }

    public void setTagLine(String tagLine) {
        this.parse.tag = tagLine.isEmpty() ? "<" + this.getTag() + ">" : "<" + this.getTag() + " " + tagLine + ">";
    }

    private String getTag() {
        int index = this.parse.tag.indexOf(" ");
        if (index < 0) {
            return this.parse.tag.substring(1, this.parse.tag.length() - 1);
        }
        return this.parse.tag.substring(1, index);
    }

    public void addToTag(String annotation) {
        this.parse.addToTag(" " + annotation.trim());
    }

    public void toHtml(StringBuilder builder) {
        boolean everything;
        boolean bl = everything = this.getClass() != TablesOnParse.class;
        if (everything) {
            builder.append(this.getLeader());
            if (this.parse.tag.length() > 1) {
                builder.append(this.parse.tag);
            }
            if (this.parse.body != null) {
                builder.append(this.parse.body);
            }
        }
        for (int i = 0; i < this.size(); ++i) {
            ((TableElementOnParse)this.at(i)).toHtml(builder);
        }
        if (everything) {
            builder.append(this.parse.end);
            builder.append(this.getTrailer());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toHtml(builder);
        return builder.toString();
    }

    protected abstract To at(int var1);

    protected abstract int size();

    protected abstract void error(TestResults var1, Throwable var2);
}

