/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow;

import fitlibrary.exception.AbandonException;
import fitlibrary.exception.FitLibraryExceptionInHtml;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.method.AmbiguousActionException;
import fitlibrary.exception.method.AmbiguousNameException;
import fitlibrary.exception.method.MissingMethodException;
import fitlibrary.global.PlugBoard;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Row;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.workflow.DoCaller;
import fitlibrary.traverse.workflow.caller.ActionSpecial;
import fitlibrary.traverse.workflow.caller.CreateFromClassNameCaller;
import fitlibrary.traverse.workflow.caller.DefinedActionCaller;
import fitlibrary.traverse.workflow.caller.DoActionCaller;
import fitlibrary.traverse.workflow.caller.MultiDefinedActionCaller;
import fitlibrary.traverse.workflow.caller.PostFixSpecialCaller;
import fitlibrary.traverse.workflow.caller.SpecialCaller;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.option.None;
import fitlibrary.utility.option.Option;
import fitlibrary.utility.option.Some;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DispatchRowInFlow {
    private static Logger logger = FitLibraryLogger.getLogger(DispatchRowInFlow.class);
    private final Evaluator evaluator;
    private final boolean sequencing;
    private boolean dynamicSequencing;

    public DispatchRowInFlow(Evaluator evaluator, boolean sequencing) {
        this.evaluator = evaluator;
        this.sequencing = sequencing;
        this.dynamicSequencing = sequencing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TypedObject interpretRow(Row row, TestResults testResults) {
        DoCaller[] doCallers = this.createDoCallers(row, this.sequencing);
        try {
            Option<String> partialError;
            DispatchRowInFlow.checkForAmbiguity(doCallers);
            Option<TypedObject> result = this.pickAndRunValidCaller(doCallers, row, testResults);
            if (result.isSome()) {
                return result.get();
            }
            if (row.size() > 2 && !this.sequencing) {
                this.dynamicSequencing = true;
                try {
                    DoCaller[] seqDoCallers = this.createDoCallers(row, true);
                    DispatchRowInFlow.checkForAmbiguity(seqDoCallers);
                    Option<TypedObject> seqResult = this.pickAndRunValidCaller(seqDoCallers, row, testResults);
                    if (seqResult.isSome()) {
                        TypedObject typedObject = seqResult.get();
                        return typedObject;
                    }
                }
                finally {
                    this.dynamicSequencing = false;
                }
            }
            if ((partialError = this.pickPartialError(doCallers)).isSome()) {
                throw new FitLibraryExceptionInHtml(partialError.get());
            }
            this.methodsAreMissing(doCallers, this.possibleSeq(row));
            return GenericTypedObject.NULL;
        }
        catch (IgnoredException ex) {
            return GenericTypedObject.NULL;
        }
        catch (AbandonException e) {
            row.ignore(testResults);
            return GenericTypedObject.NULL;
        }
        catch (Exception ex) {
            row.error(testResults, ex);
        }
        return GenericTypedObject.NULL;
    }

    public boolean isDynamicSequencing() {
        return this.dynamicSequencing;
    }

    protected DoCaller[] createDoCallers(Row row, boolean sequenced) {
        return new DoCaller[]{new DefinedActionCaller(row, this.evaluator.getRuntimeContext()), new MultiDefinedActionCaller(row, this.evaluator.getRuntimeContext()), new SpecialCaller(row, this.evaluator, PlugBoard.lookupTarget), new PostFixSpecialCaller(row, this.evaluator, sequenced), new CreateFromClassNameCaller(row, this.evaluator), new DoActionCaller(row, this.evaluator, sequenced, PlugBoard.lookupTarget), new ActionSpecial(row, this.evaluator, sequenced, PlugBoard.lookupTarget)};
    }

    private Option<TypedObject> pickAndRunValidCaller(DoCaller[] actions, Row row, TestResults testResults) throws Exception {
        for (int i = 0; i < actions.length; ++i) {
            if (!actions[i].isValid()) continue;
            TypedObject result = actions[i].run(row, testResults);
            if (this.evaluator.getRuntimeContext().isAbandoned(testResults) && !testResults.problems()) {
                row.ignore(testResults);
            }
            return new Some<TypedObject>(result);
        }
        return None.none();
    }

    private Option<String> pickPartialError(DoCaller[] actions) {
        for (int i = 0; i < actions.length; ++i) {
            if (!actions[i].partiallyValid()) continue;
            return new Some<String>(actions[i].getPartialErrorMessage());
        }
        return None.none();
    }

    private String possibleSeq(Row row) {
        if (row.size() < 3) {
            return "";
        }
        String result = "public Type " + this.evaluator.getRuntimeContext().extendedCamel(row.text(0, this.evaluator)) + "(";
        if (row.size() > 0) {
            result = result + "Type p1";
        }
        for (int i = 2; i < row.size(); ++i) {
            result = result + ", Type p" + i;
        }
        return result + ") {}";
    }

    private static void checkForAmbiguity(DoCaller[] callers) {
        String AND = " AND ";
        String message = "";
        int valids = 0;
        boolean locallyAmbiguous = false;
        for (int i = 0; i < callers.length; ++i) {
            DoCaller caller = callers[i];
            if (caller.isValid()) {
                ++valids;
                message = message + " AND " + caller.ambiguityErrorMessage();
                continue;
            }
            if (!caller.isAmbiguous()) continue;
            locallyAmbiguous = true;
            message = message + " AND " + caller.ambiguityErrorMessage();
        }
        if (locallyAmbiguous || valids > 1) {
            throw new AmbiguousActionException(message.substring(" AND ".length()));
        }
    }

    private void methodsAreMissing(DoCaller[] actions, String possibleSequenceCall) {
        ArrayList<String> missingMethods = new ArrayList<String>();
        ArrayList possibleClasses = new ArrayList();
        String ambiguousMethods = "";
        for (int i = 0; i < actions.length; ++i) {
            if (!actions[i].isProblem()) continue;
            Exception exception = actions[i].problem();
            if (exception instanceof MissingMethodException) {
                MissingMethodException missingMethodException = (MissingMethodException)exception;
                missingMethods.addAll(missingMethodException.getMethodSignature());
                for (Class<?> c : missingMethodException.getClasses()) {
                    if (possibleClasses.contains(c)) continue;
                    possibleClasses.add(c);
                }
                continue;
            }
            if (exception instanceof AmbiguousNameException) {
                AmbiguousNameException ambiguousNameException = (AmbiguousNameException)exception;
                ambiguousMethods = ambiguousMethods + "<li>" + ambiguousNameException.getMessage() + "</li>";
                continue;
            }
            if (exception instanceof ClassNotFoundException) {
                ClassNotFoundException cnf = (ClassNotFoundException)exception;
                if (cnf.getCause() != null) {
                    System.out.println("methodsAreMissing(): CNFE: " + exception.getMessage() + ": " + cnf.getCause().getMessage());
                } else {
                    System.out.println("methodsAreMissing(): CNFE: " + exception.getMessage());
                }
                missingMethods.add(exception.getMessage());
                continue;
            }
            missingMethods.add(exception.getMessage());
        }
        if (!missingMethods.isEmpty() && !possibleSequenceCall.isEmpty()) {
            missingMethods.add(possibleSequenceCall);
        }
        String message = "";
        if (ambiguousMethods.isEmpty()) {
            message = message + "Missing class or ";
        }
        if (!missingMethods.isEmpty()) {
            message = message + "Missing method. Possibly:" + MissingMethodException.htmlListOfSignatures(missingMethods);
        }
        if (!ambiguousMethods.isEmpty()) {
            message = message + "<ul>" + ambiguousMethods + "</ul>";
        }
        if (!possibleClasses.isEmpty()) {
            message = message + "<hr/>Possibly in class:" + MissingMethodException.htmlListOfClassNames(possibleClasses);
        }
        throw new FitLibraryExceptionInHtml(message.trim());
    }
}

