/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.typed;

import fitlibrary.object.Finder;
import fitlibrary.object.NonGenericFinder;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.ParserSelectorForType;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ClassUtility;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.lang.reflect.InvocationTargetException;

public class NonGenericTyped
implements Typed {
    private Class<?> classType;
    private boolean hasMethodOrField;
    private static ParserSelectorForType parserSelector = new ParserSelectorForType();

    public NonGenericTyped(Class<?> classType) {
        this.classType = classType;
    }

    public NonGenericTyped(Class<?> classType, boolean hasMethodOrField) {
        this(classType);
        this.hasMethodOrField = hasMethodOrField;
    }

    @Override
    public Class<?> asClass() {
        return this.classType;
    }

    @Override
    public boolean hasMethodOrField() {
        return this.hasMethodOrField;
    }

    @Override
    public Typed getComponentTyped() {
        return new NonGenericTyped(this.classType.getComponentType());
    }

    @Override
    public boolean isPrimitive() {
        return this.classType.isPrimitive();
    }

    @Override
    public boolean isArray() {
        return this.classType.isArray();
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return this.asClass().isEnum();
    }

    @Override
    public Object newInstance() throws InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        return ClassUtility.newInstance(this.asClass());
    }

    @Override
    public String getClassName() {
        return this.asClass().getName();
    }

    @Override
    public String simpleClassName() {
        return ClassUtility.simpleClassName(this.asClass());
    }

    @Override
    public TypedObject typedObject(Object subject) {
        return new GenericTypedObject(subject);
    }

    @Override
    public TypedObject newTypedInstance() throws InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        return this.typedObject(this.newInstance());
    }

    @Override
    public Parser parser(Evaluator evaluator) {
        return parserSelector.parserFor(evaluator, this, false);
    }

    @Override
    public Parser resultParser(Evaluator evaluator) {
        return parserSelector.parserFor(evaluator, this, true);
    }

    @Override
    public Parser on(Evaluator evaluator, Typed typed, boolean isResult) {
        return parserSelector.parserFor(evaluator, typed, isResult);
    }

    public String toString() {
        return this.classType.toString();
    }

    @Override
    public Finder getFinder(Evaluator evaluator) {
        return new NonGenericFinder(this, evaluator);
    }
}

