/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.utility;

import fitlibrary.utility.CollectionUtility;
import fitlibrary.utility.FileAccess;
import fitlibrary.utility.HtmlReceiver;
import fitlibrary.utility.NullIterator;
import fitlibrary.utility.SimpleWikiTranslator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestSimpleWikiTranslator {
    protected List<File> files = new ArrayList<File>();
    protected Map<File, List<String>> fileContents = new HashMap<File, List<String>>();
    protected SimpleWikiTranslator simpleWikiTranslator = new SimpleWikiTranslator(new FileAccess(){

        @Override
        public Iterator<File> filesWithSuffix(String string) {
            return TestSimpleWikiTranslator.this.files.iterator();
        }

        @Override
        public NullIterator<String> linesOf(File file) {
            return new NullIterator<String>(TestSimpleWikiTranslator.this.fileContents.get(file).iterator());
        }
    });
    Mockery context = new Mockery();
    protected HtmlReceiver receiver = (HtmlReceiver)this.context.mock(HtmlReceiver.class);

    @Test
    public void onlyText() {
        this.createFile("/a/b", "a", "b");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HtmlReceiver)this.oneOf(TestSimpleWikiTranslator.this.receiver)).take(new File("/a/b"), "<html>\n<br/>a<br/>\nb<br/>\n</html>");
            }
        });
        this.simpleWikiTranslator.translate(this.receiver);
    }

    @Test
    public void commentedOutText() {
        this.createFile("/a/b", "#a", "b");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HtmlReceiver)this.oneOf(TestSimpleWikiTranslator.this.receiver)).take(new File("/a/b"), "<html>\n<br/>b<br/>\n</html>");
            }
        });
        this.simpleWikiTranslator.translate(this.receiver);
    }

    @Test
    public void oneRowInOneTable() {
        this.createFile("/a/b", "|a|");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HtmlReceiver)this.oneOf(TestSimpleWikiTranslator.this.receiver)).take(new File("/a/b"), "<html>\n<br/><table border=\"1\" cellspacing=\"0\">\n<tr><td>a</td></tr>\n</table>\n<br/></html>");
            }
        });
        this.simpleWikiTranslator.translate(this.receiver);
    }

    @Test
    public void oneRowInOneTableWithText() {
        this.createFile("/a/b", "b", "|a|", "c");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HtmlReceiver)this.oneOf(TestSimpleWikiTranslator.this.receiver)).take(new File("/a/b"), "<html>\n<br/>b<br/>\n<table border=\"1\" cellspacing=\"0\">\n<tr><td>a</td></tr>\n</table>\n<br/>c<br/>\n</html>");
            }
        });
        this.simpleWikiTranslator.translate(this.receiver);
    }

    @Test
    public void twoRowsInOneTable() {
        this.createFile("/a/b", "|a|", "|b|");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HtmlReceiver)this.oneOf(TestSimpleWikiTranslator.this.receiver)).take(new File("/a/b"), "<html>\n<br/><table border=\"1\" cellspacing=\"0\">\n<tr><td>a</td></tr>\n<tr><td>b</td></tr>\n</table>\n<br/></html>");
            }
        });
        this.simpleWikiTranslator.translate(this.receiver);
    }

    @Test
    public void twoRowsSecondBlankInOneTable() {
        this.createFile("/a/b", "|a|", "| |");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HtmlReceiver)this.oneOf(TestSimpleWikiTranslator.this.receiver)).take(new File("/a/b"), "<html>\n<br/><table border=\"1\" cellspacing=\"0\">\n<tr><td>a</td></tr>\n<tr><td></td></tr>\n</table>\n<br/></html>");
            }
        });
        this.simpleWikiTranslator.translate(this.receiver);
    }

    @Test
    public void splitWorks() {
        MatcherAssert.assertThat(SimpleWikiTranslator.split(""), (Matcher)CoreMatchers.is(new ArrayList()));
        MatcherAssert.assertThat(SimpleWikiTranslator.split("||"), (Matcher)CoreMatchers.is(CollectionUtility.list("")));
        MatcherAssert.assertThat(SimpleWikiTranslator.split("| |"), (Matcher)CoreMatchers.is(CollectionUtility.list("")));
        MatcherAssert.assertThat(SimpleWikiTranslator.split("|aa|b |"), (Matcher)CoreMatchers.is(CollectionUtility.list("aa", "b")));
    }

    @Test
    public void twoOneRowTables() {
        this.createFile("/a/b", "|a|", "b", "|c|");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HtmlReceiver)this.oneOf(TestSimpleWikiTranslator.this.receiver)).take(new File("/a/b"), "<html>\n<br/><table border=\"1\" cellspacing=\"0\">\n<tr><td>a</td></tr>\n</table>\n<br/>b<br/>\n<table border=\"1\" cellspacing=\"0\">\n<tr><td>c</td></tr>\n</table>\n<br/></html>");
            }
        });
        this.simpleWikiTranslator.translate(this.receiver);
    }

    @Test
    public void definedAction() {
        this.createFile("/a/b", "|a|", "", "|b|", "----");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HtmlReceiver)this.oneOf(TestSimpleWikiTranslator.this.receiver)).take(new File("/a/b"), "<html>\n<br/><table border=\"1\" cellspacing=\"0\">\n<tr><td>a</td></tr>\n</table>\n<br/><br/>\n<table border=\"1\" cellspacing=\"0\">\n<tr><td>b</td></tr>\n</table>\n<br/><hr/>\n</html>");
            }
        });
        this.simpleWikiTranslator.translate(this.receiver);
    }

    @Test
    public void italicQuotesAreRemoved() {
        this.createFile("/a/b", "|''a''|");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HtmlReceiver)this.oneOf(TestSimpleWikiTranslator.this.receiver)).take(new File("/a/b"), "<html>\n<br/><table border=\"1\" cellspacing=\"0\">\n<tr><td>a</td></tr>\n</table>\n<br/></html>");
            }
        });
        this.simpleWikiTranslator.translate(this.receiver);
    }

    @Test
    public void boldQuotesAreRemoved() {
        this.createFile("/a/b", "|'''a'''|");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HtmlReceiver)this.oneOf(TestSimpleWikiTranslator.this.receiver)).take(new File("/a/b"), "<html>\n<br/><table border=\"1\" cellspacing=\"0\">\n<tr><td>a</td></tr>\n</table>\n<br/></html>");
            }
        });
        this.simpleWikiTranslator.translate(this.receiver);
    }

    @Test
    public void singleQuotesAreNotRemoved() {
        this.createFile("/a/b", "|'a'|");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HtmlReceiver)this.oneOf(TestSimpleWikiTranslator.this.receiver)).take(new File("/a/b"), "<html>\n<br/><table border=\"1\" cellspacing=\"0\">\n<tr><td>'a'</td></tr>\n</table>\n<br/></html>");
            }
        });
        this.simpleWikiTranslator.translate(this.receiver);
    }

    @Test
    public void wikiEscapesAreRemoved() {
        this.createFile("/a/b", "|!-a-!|");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HtmlReceiver)this.oneOf(TestSimpleWikiTranslator.this.receiver)).take(new File("/a/b"), "<html>\n<br/><table border=\"1\" cellspacing=\"0\">\n<tr><td>a</td></tr>\n</table>\n<br/></html>");
            }
        });
        this.simpleWikiTranslator.translate(this.receiver);
    }

    @Test
    public void wikiEscapesAreRemovedButBarRemains() {
        this.createFile("/a/b", "|!-a|b-!|");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HtmlReceiver)this.oneOf(TestSimpleWikiTranslator.this.receiver)).take(new File("/a/b"), "<html>\n<br/><table border=\"1\" cellspacing=\"0\">\n<tr><td>a|b</td></tr>\n</table>\n<br/></html>");
            }
        });
        this.simpleWikiTranslator.translate(this.receiver);
    }

    @Test
    public void contentsTableIsRemoved() {
        this.createFile("/a/b", "|!contents|", "", "|b|", "----");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HtmlReceiver)this.oneOf(TestSimpleWikiTranslator.this.receiver)).take(new File("/a/b"), "<html>\n<br/><br/>\n<br/>\n<table border=\"1\" cellspacing=\"0\">\n<tr><td>b</td></tr>\n</table>\n<br/><hr/>\n</html>");
            }
        });
        this.simpleWikiTranslator.translate(this.receiver);
    }

    @Test
    public void plainTextIsConverted() {
        this.createFile("/a/b", "- some action call");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HtmlReceiver)this.oneOf(TestSimpleWikiTranslator.this.receiver)).take(new File("/a/b"), "<html>\n<br/>\n<table border=\"1\" cellspacing=\"0\"><tr><td><i>run plain</i></td><td>some action call</td></tr>\n</table>\n<br/>\n</html>");
            }
        });
        this.simpleWikiTranslator.translate(this.receiver);
    }

    @Test
    public void stringToString() {
        MatcherAssert.assertThat((Object)SimpleWikiTranslator.translate("|a|"), (Matcher)CoreMatchers.is((Object)"<html>\n<br/><table border=\"1\" cellspacing=\"0\">\n<tr><td>a</td></tr>\n</table>\n<br/></html>"));
    }

    @Test
    public void secondDefinedActionBodyIsEmpty() {
        MatcherAssert.assertThat((Object)SimpleWikiTranslator.translate("|a|\n\n|comment|\n----\n|b|\n"), (Matcher)CoreMatchers.is((Object)"<html>\n<br/><table border=\"1\" cellspacing=\"0\">\n<tr><td>a</td></tr>\n</table>\n<br/><br/>\n<table border=\"1\" cellspacing=\"0\">\n<tr><td>comment</td></tr>\n</table>\n<br/><hr/>\n<table border=\"1\" cellspacing=\"0\">\n<tr><td>b</td></tr>\n</table>\n<br/></html>"));
    }

    private void createFile(String string, String ... stringArray) {
        File file = new File(string);
        this.files.add(file);
        this.fileContents.put(file, Arrays.asList(stringArray));
    }
}

