/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.date;

import fitlibrary.DoFixture;
import fitlibrary.annotation.NullaryAction;
import fitlibrary.annotation.SimpleAction;
import fitlibrary.exception.FitLibraryException;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CreateDate
extends DoFixture {
    private DateTime dateTime = new DateTime();
    private long millis = -1L;
    private boolean toUpper = false;
    private String formatString = "d MMM yyyy";

    public CreateDate() {
    }

    public CreateDate(long millis) {
        this.millis = millis;
        this.dateTime = new DateTime(millis);
    }

    public void dateIsUsing(String date, String parseFormat) {
        this.dateTime = DateTimeFormat.forPattern((String)parseFormat).parseDateTime(date);
    }

    public String result() {
        return this.formatted(this.dateTime);
    }

    @SimpleAction(wiki="|''<i>+</i>''|years|''<i>years</i>''|", tooltip="Add the given number of years to the current date.")
    public void plusYears(int offset) {
        this.dateTime = this.dateTime.plusYears(offset);
    }

    @SimpleAction(wiki="|''<i>+</i>''|months|''<i>months</i>''|", tooltip="Add the given number of months to the current date.")
    public void plusMonths(int offset) {
        this.dateTime = this.dateTime.plusMonths(offset);
    }

    @SimpleAction(wiki="|''<i>+</i>''|weeks|''<i>weeks</i>''|", tooltip="Add the given number of weeks to the current date.")
    public void plusWeeks(int offset) {
        this.dateTime = this.dateTime.plusWeeks(offset);
    }

    @SimpleAction(wiki="|''<i>+</i>''|days|''<i>days</i>''|", tooltip="Add the given number of days to the current date.")
    public void plusDays(int offset) {
        this.dateTime = this.dateTime.plusDays(offset);
    }

    @SimpleAction(wiki="|''<i>+</i>''|hours|''<i>hours</i>''|", tooltip="Add the given number of hours to the current date.")
    public void plusHours(int offset) {
        this.dateTime = this.dateTime.plusHours(offset);
    }

    @SimpleAction(wiki="|''<i>+</i>''|minutes|''<i>minutes</i>''|", tooltip="Add the given number of minutes to the current date.")
    public void plusMinutes(int offset) {
        this.dateTime = this.dateTime.plusMinutes(offset);
    }

    @NullaryAction(tooltip="Select the last day of the current month.")
    public void lastDayOfMonth() {
        DateTime.Property day = this.dateTime.dayOfMonth();
        this.dateTime = this.dateTime.plusDays(day.getMaximumValue() - day.get());
    }

    @SimpleAction(wiki="|''<i>-</i>''|years|''<i>years</i>''|", tooltip="Subtract the given number of years to the current date.")
    public void minusYears(int offset) {
        this.plusYears(-offset);
    }

    @SimpleAction(wiki="|''<i>-</i>''|months|''<i>months</i>''|", tooltip="Subtract the given number of months to the current date.")
    public void minusMonths(int offset) {
        this.plusMonths(-offset);
    }

    @SimpleAction(wiki="|''<i>-</i>''|weeks|''<i>weeks</i>''|", tooltip="Subtract the given number of weeks to the current date.")
    public void minusWeeks(int offset) {
        this.plusWeeks(-offset);
    }

    @SimpleAction(wiki="|''<i>-</i>''|days|''<i>days</i>''|", tooltip="Subtract the given number of days to the current date.")
    public void minusDays(int offset) {
        this.plusDays(-offset);
    }

    @SimpleAction(wiki="|''<i>-</i>''|hours|''<i>hours</i>''|", tooltip="Subtract the given number of hours to the current date.")
    public void minusHours(int offset) {
        this.plusHours(-offset);
    }

    @SimpleAction(wiki="|''<i>-</i>''|minutes|''<i>minutes</i>''|", tooltip="Subtract the given number of minutes to the current date.")
    public void minusMinutes(int offset) {
        this.plusMinutes(-offset);
    }

    @NullaryAction(tooltip="Use upper case.")
    public void toUpper() {
        this.toUpper = true;
    }

    @SimpleAction(wiki="|''<i>format</i>''|format|", tooltip="Specify the format to use.\nFor date formats available, see http://joda-time.sourceforge.net/api-release/org/joda/time/format/DateTimeFormat.html.")
    public void format(String s) {
        this.formatString = s;
    }

    @NullaryAction(tooltip="Select the next day that's a Monday (or previous, if going back in time).")
    public void onMonday() {
        this.requireDay(1);
    }

    @NullaryAction(tooltip="Select the next day that's a Tuesday (or previous, if going back in time).")
    public void onTuesday() {
        this.requireDay(2);
    }

    @NullaryAction(tooltip="Select the next day that's a Wednesday (or previous, if going back in time).")
    public void onWednesday() {
        this.requireDay(3);
    }

    @NullaryAction(tooltip="Select the next day that's a Thursday (or previous, if going back in time)")
    public void onThursday() {
        this.requireDay(4);
    }

    @NullaryAction(tooltip="Select the next day that's a Friday (or previous, if going back in time)")
    public void onFriday() {
        this.requireDay(5);
    }

    @NullaryAction(tooltip="Select the next day that's a Saturday (or previous, if going back in time)")
    public void onSaturday() {
        this.requireDay(6);
    }

    @NullaryAction(tooltip="Select the next day that's a Sunday (or previous, if going back in time)")
    public void onSunday() {
        this.requireDay(7);
    }

    @SimpleAction(wiki="|''<i>time zone</i>''|time zone ID|", tooltip="Specify the time zone to use.\nUse the help with dates action to find out the available IDs")
    public void timeZone(String timeZoneID) {
        if (!this.aValidTimeZoneID(timeZoneID)) {
            throw new FitLibraryException("Invalid time zone: use action |possible time zones| to see valid ones");
        }
        this.dateTime = this.millis > 0L ? new DateTime(this.millis, DateTimeZone.forID((String)timeZoneID)) : new DateTime(DateTimeZone.forID((String)timeZoneID));
    }

    @NullaryAction(tooltip="Provide help with formats and time zones for dates.")
    public void helpWithDates() {
        this.showAfterTable("For date formats available, see <a href='http://joda-time.sourceforge.net/api-release/org/joda/time/format/DateTimeFormat.html'>joda-time</a>");
        this.showAfterTable("");
        this.showAfterTable("Possible time zones:");
        String[] stringArray = TimeZone.getAvailableIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.showAfterTable(id);
            ++n2;
        }
    }

    @SimpleAction(wiki="|''<i>create variable</i>''|dynamic variable name|", tooltip="Assign the current date to the given dynamic variable")
    public void createVariable(String key) {
        this.setDynamicVariable(key, this.result());
    }

    @SimpleAction(wiki="|''<i>create variable</i>''|dynamic variable name|''<i>with format</i>''|format|", tooltip="Assign the current date to the given dynamic variable using the given format.\nFor date formats available, see http://joda-time.sourceforge.net/api-release/org/joda/time/format/DateTimeFormat.html.")
    public void createVariableWithFormat(String key, String format) {
        this.format(format);
        this.setDynamicVariable(key, this.result());
    }

    public void pickDateTime(long milliseconds) {
        this.millis = milliseconds;
        this.dateTime = new DateTime(milliseconds);
    }

    private int moveForwardsOrBackwards(DateTime dateTimeUpdated) {
        if (dateTimeUpdated.isBefore((ReadableInstant)this.dateTime)) {
            return -1;
        }
        return 1;
    }

    private String formatted(DateTime dateTimeUpdated) {
        DateTimeFormatter format = DateTimeFormat.forPattern((String)this.formatString);
        String result = dateTimeUpdated.toString(format);
        if (this.toUpper) {
            return result.toUpperCase();
        }
        return result;
    }

    private boolean aValidTimeZoneID(String timeZoneID) {
        String[] stringArray = TimeZone.getAvailableIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id.equals(timeZoneID)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void requireDay(int day) {
        int deltaDay = this.moveForwardsOrBackwards(this.dateTime);
        while (this.dateTime.dayOfWeek().get() != day) {
            this.dateTime = this.dateTime.plusDays(deltaDay);
        }
    }
}

