/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.email;

import fitlibrary.differences.LocalFile;
import fitlibrary.log.Log;
import fitlibrary.traverse.Traverse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.BodyTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ElectronicMail {
    private static int port = 143;
    private Store store;
    private Folder selectedFolder;
    private int waitTimeSeconds = 0;
    private final FetchProfile fetchProfile = new FetchProfile();
    private Message selectedMessage;

    public ElectronicMail() {
        this.fetchProfile.add(FetchProfile.Item.ENVELOPE);
        this.fetchProfile.add(FetchProfile.Item.FLAGS);
        this.fetchProfile.add("X-Mailer");
    }

    public void connectUsingHostAndProtocolWithUserNameAndPassword(String host, String protocol, String username, String password) {
        Session session = Session.getInstance((Properties)System.getProperties());
        try {
            this.store = session.getStore(protocol);
            this.store.connect(host, port, username, password);
        }
        catch (NoSuchProviderException e) {
            Log.logAndThrow((Exception)((Object)e));
        }
        catch (MessagingException e) {
            Log.logAndThrow((Exception)((Object)e));
        }
    }

    public void waitUpToSecondsForMessageToArrive(int seconds) {
        this.waitTimeSeconds = seconds;
    }

    public boolean checkMessageBodyContains(String bodyPart) {
        if (this.selectedMessage == null) {
            return false;
        }
        try {
            return this.selectedMessage.match((SearchTerm)new BodyTerm(bodyPart));
        }
        catch (MessagingException e) {
            Log.logAndThrow((Exception)((Object)e));
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean selectMessageWithSubjectMatching(String subjectPart) {
        this.selectedMessage = null;
        Message[] msgs = null;
        SubjectTerm subjectTerm = new SubjectTerm(subjectPart);
        try {
            int waitingFor = 0;
            block2: while (true) {
                if (waitingFor >= this.waitTimeSeconds) {
                    return false;
                }
                msgs = this.selectedFolder.getMessages();
                this.selectedFolder.fetch(msgs, this.fetchProfile);
                Message[] messageArray = msgs;
                int n = msgs.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        this.sleepForOneSecond();
                        ++waitingFor;
                        continue block2;
                    }
                    Message message = messageArray[n2];
                    if (message.match((SearchTerm)subjectTerm)) {
                        this.selectedMessage = message;
                        return true;
                    }
                    ++n2;
                }
                break;
            }
        }
        catch (MessagingException e) {
            Log.logAndThrow((Exception)((Object)e));
        }
        return false;
    }

    private void sleepForOneSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean openFolder(String folderName) {
        try {
            this.selectedFolder = this.store.getDefaultFolder();
            this.selectedFolder = this.selectedFolder.getFolder(folderName);
            this.selectedFolder.open(2);
            return true;
        }
        catch (MessagingException e) {
            Log.logAndThrow((Exception)((Object)e));
            return false;
        }
    }

    public boolean hasAttachment(String attachmentFileName) {
        if (this.selectedMessage == null) {
            return false;
        }
        return this.findAttachment(attachmentFileName) != null;
    }

    private Part findAttachment(String attachmentFileNameInitial) {
        String attachmentFileName = attachmentFileNameInitial;
        attachmentFileName = attachmentFileName.toLowerCase();
        try {
            Multipart multipart = (Multipart)this.selectedMessage.getContent();
            int i = 0;
            int n = multipart.getCount();
            while (i < n) {
                BodyPart part = multipart.getBodyPart(i);
                String disposition = part.getDisposition();
                if (disposition != null && (disposition.equals("attachment") || disposition.equals("inline")) && part.getFileName().toLowerCase().equals(attachmentFileName)) {
                    return part;
                }
                ++i;
            }
        }
        catch (MessagingException e) {
            Log.logAndThrow((Exception)((Object)e));
        }
        catch (IOException e) {
            Log.logAndThrow(e);
        }
        return null;
    }

    public boolean downloadAttachmentToFile(String attachmentFileName, String targetFileName) throws IOException, MessagingException {
        if (this.selectedMessage == null) {
            return false;
        }
        Part part = this.findAttachment(attachmentFileName);
        if (part == null) {
            throw new FileNotFoundException(attachmentFileName);
        }
        LocalFile globalFile = Traverse.getGlobalFile((String)targetFileName);
        FileUtils.writeByteArrayToFile((File)globalFile.getFile(), (byte[])IOUtils.toByteArray((InputStream)part.getInputStream()));
        return true;
    }

    public boolean deleteMessage() {
        if (this.selectedMessage == null) {
            return false;
        }
        try {
            this.selectedMessage.setFlag(Flags.Flag.DELETED, true);
            this.selectedFolder.expunge();
            return this.selectedMessage.isExpunged();
        }
        catch (MessagingException e) {
            Log.logAndThrow((Exception)((Object)e));
            return true;
        }
    }

    public boolean disconnect() {
        try {
            if (this.selectedFolder != null) {
                this.selectedFolder.close(false);
            }
            if (this.store != null) {
                this.store.close();
            }
        }
        catch (MessagingException e) {
            Log.logAndThrow((Exception)((Object)e));
        }
        return true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.disconnect();
    }
}

