/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.mockWebServices.logger;

import fit.Fixture;
import fitlibrary.mockWebServices.logger.MockLogger;
import fitlibrary.ws.clock.Clock;
import fitlibrary.ws.clock.RealClock;
import fitlibrary.ws.message.HttpMessage;

public class ClockedLogger
implements MockLogger {
    private final Clock clock;
    private final StringBuilder logs = new StringBuilder();
    private int errorCount = 0;
    private int requests = 0;
    private int unusedCount = 0;

    public ClockedLogger() {
        this(new RealClock());
    }

    public ClockedLogger(Clock clock) {
        this.clock = clock;
    }

    @Override
    public void error(String s) {
        this.logError("Error: " + s);
    }

    @Override
    public void unused(int portNo, String s) {
        this.logError("Unused on " + portNo + ": " + s);
        ++this.unusedCount;
    }

    @Override
    public void log(String s) {
        this.logs.append(String.valueOf(this.clock.dateTime()) + " " + this.escape(s) + "\n");
    }

    @Override
    public boolean hasErrors() {
        return this.errorCount > 0;
    }

    @Override
    public int errorCount() {
        return this.errorCount;
    }

    @Override
    public String report() {
        return "Requests = " + this.requests + "\nErrors = " + (this.errorCount - this.unusedCount) + "\nUnused = " + this.unusedCount + "\n" + this.logs.toString();
    }

    private void logError(String s) {
        this.log(s);
        ++this.errorCount;
    }

    @Override
    public void responded(String context, HttpMessage request, HttpMessage response, int portNo) {
        ++this.requests;
        String contents = response.getContents().trim();
        String firstLine = "\n-----\n" + this.clock.dateTime() + " Received on " + context + ": '" + Fixture.escape((String)request.getContents()) + "'. ";
        String secondLine = "Replied with: " + response.getResultCode() + " '" + this.escape(contents) + "'\n";
        String lineBreak = "";
        if (firstLine.length() > 20) {
            lineBreak = "\n         ";
        }
        this.logs.append(String.valueOf(firstLine) + lineBreak + secondLine);
        if (!response.isOK()) {
            ++this.errorCount;
        }
    }

    private String escape(String s) {
        return Fixture.escape((String)s);
    }
}

