/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider.component;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.spider.SpiderFixture;
import fitlibrary.spider.component.SpiderComponent;
import fitlibrary.spider.polling.PollForMatches;

public class Frame
extends SpiderComponent {
    public Frame(SpiderFixture spiderFixture) {
        super(spiderFixture);
    }

    public boolean frame(final int frameNo) {
        boolean matches = this.ensureMatchesNoException(new PollForMatches(){

            @Override
            public boolean matches() {
                Frame.this.webDriver().switchTo().defaultContent().switchTo().frame(frameNo);
                return true;
            }
        });
        if (matches) {
            return true;
        }
        throw this.problem("Unavailable", "" + frameNo);
    }

    public boolean frameByName(final String frameName) {
        boolean matches = this.ensureMatchesNoException(new PollForMatches(){

            @Override
            public boolean matches() {
                Frame.this.webDriver().switchTo().defaultContent();
                String[] stringArray = frameName.split("\\.");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String framesubname = stringArray[n2];
                    Frame.this.webDriver().switchTo().frame(framesubname);
                    ++n2;
                }
                return true;
            }
        });
        if (matches) {
            return true;
        }
        throw this.problem("Unavailable", frameName);
    }

    public boolean defaultFrame() {
        boolean matches = this.ensureMatchesNoException(new PollForMatches(){

            @Override
            public boolean matches() {
                Frame.this.webDriver().switchTo().defaultContent();
                return true;
            }
        });
        if (matches) {
            return true;
        }
        throw new FitLibraryException("Unavailable");
    }
}

