/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider.component;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.spider.SpiderFixture;
import fitlibrary.spider.component.SpiderComponent;
import fitlibrary.spider.polling.PollForWithError;
import java.util.HashSet;
import java.util.Set;

public class SpiderWindow
extends SpiderComponent {
    private String initialWindowHandle;

    public SpiderWindow(SpiderFixture spiderFixture) {
        super(spiderFixture);
    }

    public String currentWindow() {
        return this.webDriver().getWindowHandle();
    }

    public boolean clickAndSelectResultingWindow(String locator) {
        final Set<String> windowHandles = this.windowHandles();
        try {
            this.spiderFixture.click(locator);
            this.spiderFixture.ensureBecomes(new PollForWithError(){

                @Override
                public String error() {
                    return "No new window appeared";
                }

                @Override
                public boolean matches() {
                    return SpiderWindow.this.windowHandles().size() > windowHandles.size();
                }
            });
            Set<String> newWindowHandles = this.windowHandles();
            for (String handle : windowHandles) {
                newWindowHandles.remove(handle);
            }
            if (newWindowHandles.size() > 1) {
                throw new FitLibraryException("More than one new window has appeared: " + newWindowHandles);
            }
            this.selectWindow(newWindowHandles.iterator().next());
            return true;
        }
        catch (FitLibraryException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw this.spiderFixture.problem(e.toString(), locator);
        }
    }

    public boolean selectInitialWindow() {
        if (this.initialWindowHandle != null) {
            return this.selectWindow(this.initialWindowHandle);
        }
        return false;
    }

    public boolean selectWindow(String name) {
        try {
            this.webDriver().switchTo().window(name);
            return true;
        }
        catch (Exception e) {
            Set<String> windowHandles = this.windowHandles();
            this.spiderFixture.showAfterTable("Possible window names are: " + windowHandles);
            return false;
        }
    }

    public boolean selectWindowWithAs(String xpath, final String value) {
        return this.selectWindowWithMatcher(xpath, new WindowMatches(){

            @Override
            public boolean matches(String elementText) {
                return elementText.equals(value);
            }
        });
    }

    public boolean selectWindowWithContains(String xpath, final String value) {
        return this.selectWindowWithMatcher(xpath, new WindowMatches(){

            @Override
            public boolean matches(String elementText) {
                return elementText.toLowerCase().contains(value.toLowerCase());
            }
        });
    }

    private boolean selectWindowWithMatcher(String xpath, WindowMatches matcher) {
        String currentwindow = this.currentWindow();
        Set<String> windowHandles = this.windowHandles();
        for (String name : windowHandles) {
            this.webDriver().switchTo().window(name);
            try {
                if (!matcher.matches(this.spiderFixture.collectText(this.spiderFixture.findElement(xpath)))) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.webDriver().switchTo().window(currentwindow);
        return false;
    }

    public boolean selectOtherWindow() {
        Set<String> windowHandles = this.windowHandles();
        windowHandles.remove(this.currentWindow());
        if (windowHandles.size() != 1) {
            this.spiderFixture.showAfterTable("There are more than two popup windows available: " + windowHandles);
            return false;
        }
        this.selectWindow(windowHandles.iterator().next());
        return true;
    }

    public String windows() {
        HashSet<String> windowHandles = new HashSet<String>(this.windowHandles());
        try {
            if (windowHandles.size() == 1) {
                return "" + windowHandles;
            }
            windowHandles.remove(this.currentWindow());
            return "Current: " + this.currentWindow() + " + " + windowHandles;
        }
        catch (Exception e) {
            return "No current in " + windowHandles;
        }
    }

    public boolean close() {
        this.spiderFixture.getDriverVariation().close();
        try {
            Set<String> windowHandles = this.windowHandles();
            if (windowHandles.size() == 1) {
                this.selectWindow(windowHandles.iterator().next());
            }
            return true;
        }
        catch (Exception e) {
            throw new FitLibraryException("Use |close pop up| for a pop up window: " + e);
        }
    }

    protected Set<String> windowHandles() {
        return this.webDriver().getWindowHandles();
    }

    public void setInitialWindow() {
        this.initialWindowHandle = this.currentWindow();
    }

    private static interface WindowMatches {
        public boolean matches(String var1);
    }
}

