/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.ws.mock.requestMatcher;

import fitlibrary.mockWebServices.requestMatcher.AcceptAnyRequestMatcher;
import fitlibrary.mockWebServices.requestMatcher.RequestMatcher;
import fitlibrary.mockWebServices.requestMatcher.XPathMatcher;
import fitlibrary.ws.message.Message;
import fitlibrary.ws.message.ReplyMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TestXPathRequestMatcher {
    private static final String XML = "<a id=\"22\">B</a>";
    private static final Message XML_REQUEST = TestXPathRequestMatcher.msg("<a id=\"22\">B</a>");
    private static final String XML_WITH_WHITESPACE = "\n<a id=\"22\">\n B </a>";
    private static final String WRONG_XML = "<a id=\"22\">BC</a>";
    private static final Message WRONG_XML_REQUEST = TestXPathRequestMatcher.msg("<a id=\"22\">BC</a>");
    private static final String MISSING_ID = "<a id=\"3\">BC</a>";
    private RequestMatcher matcher = new XPathMatcher("//a[@id=\"22\"]", "B");

    @Test
    public void matches() throws Exception {
        Assert.assertThat((Object)this.matcher.match(XML_REQUEST), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.matcher.match(TestXPathRequestMatcher.msg(XML_WITH_WHITESPACE)), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void mismatches() throws Exception {
        Assert.assertThat((Object)this.matcher.match(WRONG_XML_REQUEST), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)this.matcher.match(TestXPathRequestMatcher.msg(MISSING_ID)), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void and() throws Exception {
        AcceptAnyRequestMatcher acceptAnyRequestMatcher = new AcceptAnyRequestMatcher();
        Assert.assertThat((Object)this.matcher.and(acceptAnyRequestMatcher).match(XML_REQUEST), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.matcher.and(acceptAnyRequestMatcher).match(WRONG_XML_REQUEST), (Matcher)Matchers.equalTo((Object)false));
    }

    private static ReplyMessage msg(String string) {
        return new ReplyMessage(string);
    }
}

