/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.calendar.impl;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.zkoss.calendar.api.DateFormatter;

public class SimpleDateFormatter
implements DateFormatter,
Serializable {
    private static final long serialVersionUID = 20090316151208L;
    private String _dayFormat = "EEE MM/d";
    private String _weekFormat = "EEE";
    private String _timeFormat = "HH:mm";
    private String _ppFormat = "EEE, MMM/d";
    private SimpleDateFormat _df;
    private SimpleDateFormat _wf;
    private SimpleDateFormat _tf;
    private SimpleDateFormat _pf;

    public String getCaptionByDate(Date date, Locale locale, TimeZone timezone) {
        if (this._df == null) {
            this._df = new SimpleDateFormat(this._dayFormat, locale);
        }
        this._df.setTimeZone(timezone);
        return this._df.format(date);
    }

    public String getCaptionByDateOfMonth(Date date, Locale locale, TimeZone timezone) {
        Calendar cal = Calendar.getInstance(timezone, locale);
        cal.setTime(date);
        if (cal.get(5) == 1) {
            SimpleDateFormat sd = new SimpleDateFormat("MMM d", locale);
            sd.setTimeZone(timezone);
            return sd.format(date);
        }
        return Integer.toString(cal.get(5));
    }

    public String getCaptionByDayOfWeek(Date date, Locale locale, TimeZone timezone) {
        if (this._wf == null) {
            this._wf = new SimpleDateFormat(this._weekFormat, locale);
        }
        this._wf.setTimeZone(timezone);
        return this._wf.format(date);
    }

    public String getCaptionByTimeOfDay(Date date, Locale locale, TimeZone timezone) {
        if (this._tf == null) {
            this._tf = new SimpleDateFormat(this._timeFormat, locale);
        }
        this._tf.setTimeZone(timezone);
        return this._tf.format(date);
    }

    public String getCaptionByPopup(Date date, Locale locale, TimeZone timezone) {
        if (this._pf == null) {
            this._pf = new SimpleDateFormat(this._ppFormat, locale);
        }
        this._pf.setTimeZone(timezone);
        return this._pf.format(date);
    }

    public String getCaptionByWeekOfYear(Date date, Locale locale, TimeZone timezone) {
        Calendar cal = Calendar.getInstance(timezone, locale);
        cal.setTime(date);
        return String.valueOf(cal.get(3));
    }
}

