/*
 * Decompiled with CFR 0.152.
 */
package test.performance;

import java.text.DecimalFormat;
import java.util.Date;
import org.compiere.model.MProduct;
import test.AdempiereTestCase;

public class MProductTest
extends AdempiereTestCase {
    private MProduct product = null;
    private int AD_Org_ID = 0;
    private int M_Product_Category_ID = 0;
    private int C_TaxCategory_ID = 0;
    private int C_UOM_ID = 0;
    private String ProductType = null;
    private int startIndex = 43000;
    private int runCount = 500;
    private boolean singleCommit = false;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.AD_Org_ID = Integer.parseInt(this.testProperties.getProperty("AD_Org_ID", "0"));
        this.M_Product_Category_ID = Integer.parseInt(this.testProperties.getProperty("M_Product_Category_ID", "105"));
        this.C_TaxCategory_ID = Integer.parseInt(this.testProperties.getProperty("C_TaxCategory_ID", "107"));
        this.C_UOM_ID = Integer.parseInt(this.testProperties.getProperty("C_UOM_ID", "100"));
        this.ProductType = this.testProperties.getProperty("ProductType", "I");
        this.startIndex = Integer.parseInt(this.testProperties.getProperty("startIndex", "43000"));
        this.runCount = Integer.parseInt(this.testProperties.getProperty("runCount", "500"));
        this.singleCommit = Boolean.parseBoolean(this.testProperties.getProperty("singleCommit", "false"));
    }

    public void testMProductCreation() {
        long startTime = System.currentTimeMillis();
        System.out.println("Start Time(ms) = " + startTime);
        System.out.println("Start Time     = " + new Date(startTime));
        DecimalFormat formatter = new DecimalFormat("00000");
        int idx = this.startIndex;
        while (idx < this.startIndex + this.runCount) {
            this.product = new MProduct(this.getCtx(), 0, this.getTrxName());
            String formattedIdx = formatter.format(idx);
            this.product.setValue("test-product-" + formattedIdx);
            this.product.setName("Test Product " + formattedIdx);
            this.product.setAD_Org_ID(this.AD_Org_ID);
            this.product.setM_Product_Category_ID(this.M_Product_Category_ID);
            this.product.setC_TaxCategory_ID(this.C_TaxCategory_ID);
            this.product.setC_UOM_ID(this.C_UOM_ID);
            this.product.setProductType(this.ProductType);
            boolean saveResult = this.product.save();
            MProductTest.assertTrue((String)"MProduct.save()", (boolean)saveResult);
            if (this.singleCommit) {
                try {
                    this.commit();
                }
                catch (Exception e) {
                    MProductTest.fail((String)e.getLocalizedMessage());
                }
            }
            ++idx;
        }
        if (!this.singleCommit) {
            try {
                this.commit();
            }
            catch (Exception e) {
                MProductTest.fail((String)e.getLocalizedMessage());
            }
        }
        long endTime = System.currentTimeMillis();
        System.out.println("End Time(ms) = " + endTime);
        System.out.println("End Time     = " + new Date(endTime));
        long time = endTime - startTime;
        System.out.println("Duration(ms) = " + time);
        System.out.println("Duration(sec.) = " + (time /= 1000L));
        if (time > 0L) {
            System.out.println("Duration(min.) = " + time / 60L);
        }
        System.out.println("Count = " + this.runCount + "; Time(seconds) = " + time + "; Produsts/Second = " + (float)this.runCount / (float)time + "; ");
        MProductTest.assertTrue((String)((Object)((Object)this)).getClass().getName(), (boolean)true);
    }
}

