/*
 * Decompiled with CFR 0.152.
 */
package fit.decorator;

import fit.Parse;
import fit.decorator.FixtureDecorator;
import fit.decorator.FixtureDecoratorTestCase;
import fit.decorator.Loop;
import fit.decorator.exceptions.InvalidInputException;
import fit.decorator.util.TestCaseHelper;

public class LoopTest
extends FixtureDecoratorTestCase {
    private static final String FIRST_HTML_ROW = "<tr><td>" + Loop.class.getName() + "</td><td>1</td><td>times</td></tr>";
    private FixtureDecorator decorator = new Loop();

    public void testSetupDecoratorShouldThrowInvalidInputExceptionIfLoopCountIsNotSpecified() {
        try {
            this.decorator.setupDecorator(new String[0]);
            LoopTest.fail((String)"Should blow up");
        }
        catch (InvalidInputException e) {
            LoopTest.assertEquals((String)"Loop count must be specified", (String)e.getMessage());
        }
    }

    public void testSetupDecoratorShouldAddLoopCountToSummary() throws Exception {
        this.decorator.setupDecorator(new String[]{"5"});
        LoopTest.assertEquals((long)5L, (long)((Long)this.decorator.summary.get("count")));
    }

    public void testShouldExecuteDoTableMethodLoopCounterNumberOfTimes() throws Exception {
        String fitPage = "<table><tr><td>" + Loop.class.getName() + "</td><td>5</td><td>times</td></tr><tr><td>eg.Division</td></tr>" + "<tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr>" + "<tr><td>10</td><td>2</td><td>5</td></tr><tr><td>12.6</td><td>3</td><td>4.2</td></tr>" + "<tr><td>100</td><td>4</td><td>25</td></tr></table>";
        this.decorator.doTable(new Parse(fitPage));
        TestCaseHelper.assertCounts(TestCaseHelper.counts(15, 0, 0, 0), this.decorator.counts);
    }

    @Override
    protected String geDecoratorHTMLRow() {
        return FIRST_HTML_ROW;
    }

    @Override
    protected int numberOfAssertionsOnDecorator() {
        return 0;
    }
}

