/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.closure;

import fitlibrary.closure.Closure;
import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.diff.Diff_match_patch;
import fitlibrary.dynamicVariable.DynamicVariablesRecording;
import fitlibrary.exception.AbandonException;
import fitlibrary.exception.FitLibraryShowException;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.parse.NoValueProvidedException;
import fitlibrary.exception.parse.ParseException;
import fitlibrary.global.PlugBoard;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.GetterParser;
import fitlibrary.parser.lookup.ResultParser;
import fitlibrary.runResults.TestResults;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.TypedObject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class CalledMethodTarget
implements ICalledMethodTarget {
    private final Closure closure;
    private final Evaluator evaluator;
    private Parser[] parameterParsers;
    protected ResultParser resultParser = null;
    private final Object[] args;
    private String repeatString = null;
    private String exceptionString = null;
    private boolean everySecond = false;
    private final RuntimeContextInternal runtime;

    public CalledMethodTarget(Closure closure, Evaluator evaluator) {
        this.closure = closure;
        this.evaluator = evaluator;
        this.runtime = evaluator.getRuntimeContext();
        this.args = new Object[this.getParameterTypes().length];
        this.parameterParsers = closure.parameterParsers(evaluator);
        this.resultParser = closure.resultParser(evaluator);
    }

    public CalledMethodTarget(Evaluator evaluator) {
        this.evaluator = evaluator;
        this.runtime = evaluator.getRuntimeContext();
        this.parameterParsers = new Parser[0];
        this.args = new Object[0];
        this.closure = null;
        this.resultParser = null;
    }

    public boolean isValid() {
        return this.closure != null;
    }

    @Override
    public Class<?> getOwningClass() {
        return this.closure.getOwningClass();
    }

    @Override
    public Class<?> getReturnType() {
        return this.closure.getReturnType();
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.closure.getParameterTypes();
    }

    @Override
    public Object invoke(Object[] arguments) throws Exception {
        return this.closure.invoke(arguments);
    }

    public TypedObject invokeTyped(Object[] arguments) throws Exception {
        return this.closure.invokeTyped(arguments);
    }

    @Override
    public Object invoke(Cell cell, TestResults testResults) throws Exception {
        this.collectCell(cell, 0, cell.text(this.runtime), testResults, true);
        return this.invoke(this.args);
    }

    @Override
    public TypedObject invokeTyped(Row row, TestResults testResults) throws Exception {
        try {
            if (this.everySecond) {
                this.collectCells(row, 2, testResults, true);
            } else {
                this.collectCells(row, 1, testResults, true);
            }
        }
        catch (AbandonException e) {
            throw new IgnoredException(e);
        }
        catch (Exception e) {
            throw new IgnoredException(e);
        }
        try {
            return this.invokeTyped(this.args);
        }
        catch (AbandonException e) {
            throw new IgnoredException();
        }
    }

    @Override
    public Object invoke(Row row, TestResults testResults, boolean catchParseError) throws Exception {
        try {
            if (this.everySecond) {
                this.collectCells(row, 2, testResults, catchParseError);
            } else {
                this.collectCells(row, 1, testResults, catchParseError);
            }
        }
        catch (Exception e) {
            throw new IgnoredException(e);
        }
        return this.invoke(this.args);
    }

    @Override
    public Object invokeForSpecial(Row row, TestResults testResults, boolean catchParseError, Cell operatorCell) throws Exception {
        try {
            if (this.everySecond) {
                this.collectCells(row, 2, testResults, catchParseError);
            } else {
                this.collectCells(row, 1, testResults, catchParseError);
            }
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgnoredException(e);
        }
        try {
            return this.invoke(this.args);
        }
        catch (InvocationTargetException e) {
            Throwable embedded = PlugBoard.exceptionHandling.unwrapThrowable(e);
            if (embedded instanceof FitLibraryShowException) {
                operatorCell.error(testResults);
            }
            throw e;
        }
    }

    private void collectCells(Row row, int step, TestResults testResults, boolean catchParseError) throws Exception {
        for (int argNo = 0; argNo < this.args.length; ++argNo) {
            Cell cell = (Cell)row.at(argNo * step);
            this.collectCell(cell, argNo, cell.text(this.runtime), testResults, catchParseError);
        }
    }

    private void collectCell(Cell cell, int argNo, String text, TestResults testResults, boolean catchParseError) throws Exception {
        try {
            if (!text.equals(this.repeatString)) {
                this.args[argNo] = this.parameterParsers[argNo].parseTyped(cell, testResults).getSubject();
            }
        }
        catch (Exception e) {
            if (catchParseError) {
                cell.error(testResults, e);
                throw new IgnoredException();
            }
            throw e;
        }
    }

    @Override
    public void invokeAndCheck(Row row, Cell expectedCell, TestResults testResults, boolean handleSubtype) {
        boolean exceptionExpected = this.exceptionIsExpected(expectedCell);
        try {
            Object result = this.invoke(row, testResults, true);
            if (exceptionExpected) {
                expectedCell.fail(testResults);
            } else {
                this.checkResult(expectedCell, result, true, handleSubtype, testResults);
            }
        }
        catch (IgnoredException ex) {
        }
        catch (Exception e) {
            expectedCell.exceptionExpected(exceptionExpected, e, testResults);
        }
    }

    @Override
    public void invokeAndCheckForSpecial(Row row, Cell expectedCell, TestResults testResults, Row fullRow, Cell specialCell) {
        boolean exceptionExpected = this.exceptionIsExpected(expectedCell);
        try {
            Object result = this.invoke(row, testResults, true);
            DynamicVariablesRecording recorder = this.runtime.getDynamicVariableRecorder();
            if (recorder.isRecording() && expectedCell.unresolved(this.runtime)) {
                String text = expectedCell.text();
                String key = text.substring(2, text.length() - 1);
                String resultString = result.toString();
                if (!resultString.contains("@{" + key + "}")) {
                    this.runtime.setDynamicVariable(key, resultString);
                    recorder.record(key, resultString);
                }
                expectedCell.pass(testResults, resultString);
                return;
            }
            if (exceptionExpected) {
                expectedCell.fail(testResults);
            } else {
                this.checkResult(expectedCell, result, true, false, testResults);
            }
        }
        catch (IgnoredException e) {
        }
        catch (InvocationTargetException e) {
            Throwable embedded = e.getTargetException();
            if (embedded instanceof FitLibraryShowException) {
                specialCell.error(testResults);
                fullRow.error(testResults, e);
            } else {
                expectedCell.exceptionExpected(exceptionExpected, e, testResults);
            }
        }
        catch (Exception e) {
            expectedCell.exceptionExpected(exceptionExpected, e, testResults);
        }
    }

    private boolean exceptionIsExpected(Cell expectedCell) {
        return this.exceptionString != null && this.exceptionString.equals(expectedCell.text(this.runtime));
    }

    @Override
    public String getResult() throws Exception {
        return this.resultParser.show(this.invoke());
    }

    @Override
    public boolean invokeAndCheckCell(Cell expectedCell, boolean matchedAlready, TestResults testResults) {
        try {
            return this.checkResult(expectedCell, this.invoke(), matchedAlready, false, testResults);
        }
        catch (Exception e) {
            expectedCell.error(testResults, e);
            return false;
        }
    }

    @Override
    public Object invoke() throws Exception {
        return this.closure.invoke();
    }

    @Override
    public boolean matches(Cell expectedCell, TestResults testResults) {
        try {
            return this.resultParser.matches(expectedCell, this.invoke(), testResults);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean checkResult(Cell expectedCell, Object initialResult, boolean showWrongs, boolean handleSubtype, TestResults testResults) {
        ArrayList result = initialResult;
        if (result != null && Iterator.class.isAssignableFrom(result.getClass())) {
            Iterator it = (Iterator)((Object)result);
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            result = list;
        }
        ResultParser valueParser = this.resultParser;
        if (handleSubtype && this.closure != null) {
            valueParser = this.closure.specialisedResultParser(this.resultParser, result, this.evaluator);
        }
        try {
            if (valueParser == null) {
                throw new NoValueProvidedException();
            }
            if (valueParser.isShowAsHtml()) {
                if (valueParser.matches(expectedCell, result, testResults)) {
                    expectedCell.pass(testResults);
                    return true;
                }
                expectedCell.wrongHtml(testResults, valueParser.show(result));
                return false;
            }
            if (valueParser.matches(expectedCell, result, testResults)) {
                expectedCell.passIfNotEmbedded(testResults, this.runtime);
                return true;
            }
            if (showWrongs && (result == null || !expectedCell.hasEmbeddedTables(this.runtime))) {
                if (result instanceof String) {
                    expectedCell.failWithStringEquals(testResults, valueParser.show(result), this.runtime);
                } else {
                    expectedCell.fail(testResults, valueParser.show(result), this.runtime);
                }
            }
            return false;
        }
        catch (Exception e) {
            expectedCell.error(testResults, e);
            return false;
        }
    }

    public static String matching(String expected, String actual) {
        LinkedList<Diff_match_patch.Diff> diffs = new Diff_match_patch().diff_main(expected, actual, true);
        StringBuilder s = new StringBuilder();
        for (Diff_match_patch.Diff diff : diffs) {
            switch (diff.operation) {
                case DELETE: {
                    s.append("<strike>" + diff.text + "</strike>");
                    break;
                }
                case EQUAL: {
                    s.append(diff.text);
                    break;
                }
                case INSERT: {
                    s.append("<b>" + diff.text + "</b>");
                }
            }
        }
        return s.toString();
    }

    @Override
    public void notResult(Cell expectedCell, Object result, TestResults testResults) {
        try {
            if (this.resultParser == null) {
                throw new NoValueProvidedException();
            }
            if (!this.resultParser.matches(expectedCell, result, testResults)) {
                expectedCell.passIfNotEmbedded(testResults, this.runtime);
            } else if (!expectedCell.hasEmbeddedTables(this.runtime)) {
                expectedCell.fail(testResults);
            }
        }
        catch (Exception e) {
            expectedCell.error(testResults, e);
        }
    }

    @Override
    public Object getResult(Cell expectedCell, TestResults testResults) {
        try {
            return this.resultParser.parseTyped(expectedCell, testResults).getSubject();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void color(Row row, boolean right, TestResults testResults) throws Exception {
        if (!this.everySecond && row.atExists(0)) {
            ((Cell)row.at(0)).passOrFail(testResults, right);
        } else {
            for (int i = 0; i < row.size(); i += 2) {
                ((Cell)row.at(i)).passOrFail(testResults, right);
            }
        }
    }

    @Override
    public void setRepeatAndExceptionString(String repeatString, String exceptionString) {
        this.repeatString = repeatString;
        this.exceptionString = exceptionString;
    }

    @Override
    public void setEverySecond(boolean everySecond) {
        this.everySecond = everySecond;
    }

    @Override
    public String getResultString(Object result) throws Exception {
        if (this.getReturnType() == String.class) {
            return (String)result;
        }
        return this.resultParser.show(result);
    }

    public String toString() {
        return this.closure.toString();
    }

    @Override
    public Parser getResultParser() {
        return this.resultParser;
    }

    public void setResultParser(GetterParser resultAdapter) {
        this.resultParser = resultAdapter;
    }

    @Override
    public Parser[] getParameterParsers() {
        return this.parameterParsers;
    }

    public void setParameterParsers(Parser[] parameterAdapters) {
        this.parameterParsers = parameterAdapters;
    }

    @Override
    public void setTypedSubject(TypedObject typedObject) {
        this.closure.setTypedSubject(typedObject);
    }

    @Override
    public boolean returnsVoid() {
        return this.getReturnType() == Void.TYPE;
    }

    @Override
    public boolean returnsBoolean() {
        return this.getReturnType() == Boolean.TYPE;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CalledMethodTarget)) {
            return false;
        }
        CalledMethodTarget other = (CalledMethodTarget)obj;
        return this.closure == other.closure && this.runtime == other.runtime;
    }

    public int hashCode() {
        return this.runtime.hashCode();
    }
}

