/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.differences;

import fitlibrary.differences.DifferenceInterface;
import fitlibrary.differences.FolderRunnerGlobalFile;
import fitlibrary.differences.FolderRunnerLocalFile;
import fitlibrary.differences.LocalFile;
import fitlibrary.log.FitLibraryLogger;
import java.io.File;
import org.apache.log4j.Logger;

public class FolderRunnerDifference
implements DifferenceInterface {
    private static Logger logger = FitLibraryLogger.getLogger(FolderRunnerDifference.class);
    private static final String DOT_FILES = "files/";
    private static File CURRENT_TEST_FILE_DIRY = new File(".");

    public File getRelativeFile(String name) {
        File file = new File(CURRENT_TEST_FILE_DIRY, DOT_FILES + name);
        return file;
    }

    public File getHomeDirectory() {
        return new File(".");
    }

    public String url(File file) {
        return DOT_FILES + file.getName();
    }

    public static void setCurrentTestDiryFile(File currentTestDiryFile) {
        CURRENT_TEST_FILE_DIRY = currentTestDiryFile;
    }

    @Override
    public LocalFile getLocalFile(String localFileName) {
        logger.trace((Object)("getLocalFile(" + localFileName + ")"));
        return new FolderRunnerLocalFile(localFileName);
    }

    @Override
    public LocalFile getLocalFile(File file) {
        logger.trace((Object)("getLocalFile(File: " + file.getPath() + ")"));
        return new FolderRunnerLocalFile(file);
    }

    @Override
    public LocalFile getGlobalFile(File file) {
        logger.trace((Object)("getGlobalFile(" + file.getPath() + ")"));
        return this.getLocalFile(file);
    }

    @Override
    public LocalFile getGlobalFile(String fileName) {
        return new FolderRunnerGlobalFile(fileName);
    }

    @Override
    public void setContext(File file) {
        logger.trace((Object)("setContext(" + file.getAbsolutePath() + ")"));
        FolderRunnerLocalFile.setContext(file);
    }

    @Override
    public boolean inFitNesse() {
        return false;
    }
}

