/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.differences;

import fitlibrary.differences.LocalFile;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.utility.StringUtility;
import java.io.File;
import org.apache.log4j.Logger;

public class FolderRunnerLocalFile
implements LocalFile {
    private static Logger logger = FitLibraryLogger.getLogger(FolderRunnerLocalFile.class);
    protected File file;
    private static File CONTEXT = new File(".");

    public FolderRunnerLocalFile(File file) {
        this.file = file;
    }

    public FolderRunnerLocalFile(String localFileNameInitial) {
        String localFileName = localFileNameInitial;
        if (localFileName.startsWith("/")) {
            localFileName = localFileName.substring(1);
        }
        if (!localFileName.startsWith("files/") && !localFileName.startsWith("files\\")) {
            localFileName = "files/" + localFileName;
        }
        this.file = new File(CONTEXT, localFileName);
        logger.trace((Object)("FolderRunnerLocalFile(" + localFileNameInitial + ")"));
        logger.trace((Object)("FolderRunnerLocalFile(" + this.file.getAbsolutePath() + ") exists = " + this.file.exists()));
    }

    @Override
    public LocalFile withSuffix(String suffix) {
        String name = this.file.getPath();
        int last = name.lastIndexOf(".");
        if (last >= 0) {
            name = name.substring(0, last + 1) + suffix;
        }
        logger.trace((Object)("withSuffix(): " + name));
        return new FolderRunnerLocalFile(name);
    }

    @Override
    public File getFile() {
        logger.trace((Object)("getFile(): " + this.file.getAbsolutePath()));
        return this.file;
    }

    @Override
    public void mkdirs() throws SecurityException {
        File diry = this.file.getParentFile();
        logger.trace((Object)("mkdirs(): " + diry.getAbsolutePath()));
        if (!diry.exists()) {
            diry.mkdirs();
        }
    }

    @Override
    public String htmlImageLink() {
        return "<img src=\"file:///" + this.escape(this.file.getPath()) + "\">";
    }

    @Override
    public String htmlLink() {
        return "<a href=\"file:///" + this.escape(this.file.getPath()) + "\">" + this.file.getName() + "</a>";
    }

    protected String escape(String path) {
        return StringUtility.replaceString(path, "\\", "/").replaceAll(" ", "%20");
    }

    public boolean equals(Object object) {
        if (!(object instanceof FolderRunnerLocalFile)) {
            return false;
        }
        String absolutePath = ((FolderRunnerLocalFile)object).file.getPath();
        String otherAbsolutePath = this.file.getPath();
        boolean equals = absolutePath.equals(otherAbsolutePath);
        logger.trace((Object)(absolutePath + ".equals(" + otherAbsolutePath + ") = " + equals));
        return equals;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return "FolderRunnerLocalFile[" + this.file.getName() + "]";
    }

    public static void setContext(File context) {
        CONTEXT = context;
    }
}

