/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.flow;

import fitlibrary.flow.SetUpTearDown;
import fitlibrary.flow.SetUpTearDownReferenceCounter;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Row;
import fitlibrary.table.TableFactory;
import fitlibrary.typed.TypedObject;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class SetUpTearDownCache
implements SetUpTearDown {
    private static Logger logger = FitLibraryLogger.getLogger(SetUpTearDownCache.class);
    private final SetUpTearDownReferenceCounter referenceCounter = new SetUpTearDownReferenceCounter();

    @Override
    public void callSetUpOnSutChain(Object sutInitially, Row row, TestResults testResults) {
        Object sut = sutInitially;
        if (sut instanceof TypedObject) {
            sut = ((TypedObject)sut).getSubject();
        }
        this.referenceCounter.callSetUpOnNewReferences(sut, this.methodCaller(row, testResults));
    }

    @Override
    public void callTearDownOnSutChain(Object sut, Row row, TestResults testResults) {
        this.referenceCounter.callTearDownOnReferencesThatAreCountedDown(sut, this.methodCaller(row, testResults));
    }

    @Override
    public void callSuiteSetUp(Object suiteFixture, Row row, TestResults testResults) {
        this.callMethod(suiteFixture, "suiteSetUp", row, testResults);
    }

    @Override
    public void callSuiteTearDown(Object suiteFixture, TestResults testResults) {
        this.callMethod(suiteFixture, "suiteTearDown", TableFactory.row("a"), testResults);
    }

    private SetUpTearDownReferenceCounter.MethodCaller methodCaller(final Row row, final TestResults testResults) {
        return new SetUpTearDownReferenceCounter.MethodCaller(){

            @Override
            public void setUp(Object object) {
                SetUpTearDownCache.this.callMethod(object, "setUp", row, testResults);
            }

            @Override
            public void tearDown(Object object) {
                Object result;
                if (testResults.problems() && (result = SetUpTearDownCache.this.callMethod(object, "onFailure", row, testResults)) != null) {
                    row.addCell(result.toString()).shown();
                }
                SetUpTearDownCache.this.callMethod(object, "tearDown", row, testResults);
            }
        };
    }

    protected Object callMethod(Object object, String methodName, Row row, TestResults testResults) {
        try {
            Method method = object.getClass().getMethod(methodName, new Class[0]);
            logger.trace((Object)("Calling " + methodName + "() on " + object));
            return method.invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            row.error(testResults, e);
        }
        return null;
    }
}

