/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.flow;

import fitlibrary.flow.SetUpTearDownReferenceCounter;
import fitlibrary.traverse.DomainAdapter;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestSetUpTearDownReferenceCounter {
    Mockery context = new Mockery();
    SetUpTearDownReferenceCounter.MethodCaller methodCaller = (SetUpTearDownReferenceCounter.MethodCaller)this.context.mock(SetUpTearDownReferenceCounter.MethodCaller.class);
    SetUpTearDownReferenceCounter setUpTearDownManager = new SetUpTearDownReferenceCounter();
    DomainAdapter domainAdapter = (DomainAdapter)this.context.mock(DomainAdapter.class);

    @Test
    public void setUpNotCalledAsNotDomainObject() {
        String string = "someObj";
        this.setUpTearDownManager.callSetUpOnNewReferences(string, this.methodCaller);
    }

    @Test
    public void tearDownNotCalledAsNotDomainObject() {
        String string = "someObj";
        this.setUpTearDownManager.callTearDownOnReferencesThatAreCountedDown(string, this.methodCaller);
    }

    @Test
    public void setUpCalledWithNewDomainAdapter() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SetUpTearDownReferenceCounter.MethodCaller)this.oneOf(TestSetUpTearDownReferenceCounter.this.methodCaller)).setUp(TestSetUpTearDownReferenceCounter.this.domainAdapter);
                ((DomainAdapter)this.allowing(TestSetUpTearDownReferenceCounter.this.domainAdapter)).getSystemUnderTest();
                this.will(1.returnValue(null));
            }
        });
        this.setUpTearDownManager.callSetUpOnNewReferences(this.domainAdapter, this.methodCaller);
    }

    @Test
    public void setUpOnlyCalledOnceWithNewDomainAdapter() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SetUpTearDownReferenceCounter.MethodCaller)this.oneOf(TestSetUpTearDownReferenceCounter.this.methodCaller)).setUp(TestSetUpTearDownReferenceCounter.this.domainAdapter);
                ((DomainAdapter)this.allowing(TestSetUpTearDownReferenceCounter.this.domainAdapter)).getSystemUnderTest();
                this.will(2.returnValue(null));
            }
        });
        this.setUpTearDownManager.callSetUpOnNewReferences(this.domainAdapter, this.methodCaller);
        this.setUpTearDownManager.callSetUpOnNewReferences(this.domainAdapter, this.methodCaller);
    }

    @Test
    public void tearDownCalledWithDomainAdapter() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SetUpTearDownReferenceCounter.MethodCaller)this.oneOf(TestSetUpTearDownReferenceCounter.this.methodCaller)).setUp(TestSetUpTearDownReferenceCounter.this.domainAdapter);
                ((SetUpTearDownReferenceCounter.MethodCaller)this.oneOf(TestSetUpTearDownReferenceCounter.this.methodCaller)).tearDown(TestSetUpTearDownReferenceCounter.this.domainAdapter);
                ((DomainAdapter)this.allowing(TestSetUpTearDownReferenceCounter.this.domainAdapter)).getSystemUnderTest();
                this.will(3.returnValue(null));
            }
        });
        this.setUpTearDownManager.callSetUpOnNewReferences(this.domainAdapter, this.methodCaller);
        this.setUpTearDownManager.callTearDownOnReferencesThatAreCountedDown(this.domainAdapter, this.methodCaller);
    }

    @Test
    public void setUpAndTearDownOnlyCalledOnceWithNewDomainAdapter() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SetUpTearDownReferenceCounter.MethodCaller)this.oneOf(TestSetUpTearDownReferenceCounter.this.methodCaller)).setUp(TestSetUpTearDownReferenceCounter.this.domainAdapter);
                ((SetUpTearDownReferenceCounter.MethodCaller)this.oneOf(TestSetUpTearDownReferenceCounter.this.methodCaller)).tearDown(TestSetUpTearDownReferenceCounter.this.domainAdapter);
                ((DomainAdapter)this.allowing(TestSetUpTearDownReferenceCounter.this.domainAdapter)).getSystemUnderTest();
                this.will(4.returnValue(null));
            }
        });
        this.setUpTearDownManager.callSetUpOnNewReferences(this.domainAdapter, this.methodCaller);
        this.setUpTearDownManager.callSetUpOnNewReferences(this.domainAdapter, this.methodCaller);
        this.setUpTearDownManager.callTearDownOnReferencesThatAreCountedDown(this.domainAdapter, this.methodCaller);
        this.setUpTearDownManager.callTearDownOnReferencesThatAreCountedDown(this.domainAdapter, this.methodCaller);
    }
}

