/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.log;

import fitlibrary.log.DelegatingLogger;
import fitlibrary.log.LogDelegationConfig;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.RootLogger;

public class FixturingLogger
extends Logger {
    protected static boolean DELEGATING_TO_NORMAL_LOGGER = false;
    private static final RootLogger ROOT = new RootLogger(Level.DEBUG);
    private static final Hierarchy hierarchy = new Hierarchy((Logger)ROOT);
    private static final LoggerFactory factory = new LoggerFactory(){

        public Logger makeNewLoggerInstance(final String name) {
            return new DelegatingLogger(name, new LogDelegationConfig(){

                @Override
                public boolean isDelegating() {
                    return DELEGATING_TO_NORMAL_LOGGER;
                }

                @Override
                public Logger delegate() {
                    return Logger.getLogger((String)name);
                }
            });
        }
    };

    protected FixturingLogger() {
        super("FixturingLogger");
    }

    public static Hierarchy getOwnHierarchy() {
        return hierarchy;
    }

    public static Logger getRootLogger() {
        return ROOT;
    }

    public static Logger getLogger(String name) {
        return hierarchy.getLogger(name, factory);
    }

    public static Logger getLogger(Class<?> type) {
        return FixturingLogger.getLogger(type.getName());
    }

    public static Logger exists(String name) {
        return hierarchy.exists(name);
    }

    public static void setDelegatingToNormalLogger(boolean delegating) {
        DELEGATING_TO_NORMAL_LOGGER = delegating;
    }
}

