/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.log;

import fitlibrary.utility.ClassUtility;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;

public class Logging {
    private static AtomicBoolean LOGGING = new AtomicBoolean(false);
    private static ThreadLocal<String> tab = new ThreadLocal();
    private static final String TABBING = "  ";

    public static void setLogging(boolean logging) {
        LOGGING.set(logging);
        tab.set("");
    }

    public static void startLog(Object object, String s) {
        Logging.log(object, "Start: " + s);
        tab.set(tab.get() + TABBING);
    }

    public static void startLog(String s) {
        Logging.log("Start: " + s);
        tab.set(tab.get() + TABBING);
    }

    public static void endLog(Object object, String s) {
        Logging.log(object, "End: " + s);
        tab.set(tab.get().substring(TABBING.length()));
    }

    public static void endLog(String s) {
        Logging.log("End: " + s);
        tab.set(tab.get().substring(TABBING.length()));
    }

    public static void log(String s) {
        if (LOGGING.get()) {
            System.out.println(tab + s);
        }
    }

    public static void logCall(Object object, Method method, Object[] args) {
        Logging.log("Call " + method.getName() + "(" + Logging.argList(args) + ") in object of class " + object.getClass().getName());
    }

    private static String argList(Object[] args) {
        String result = "";
        for (int i = 0; i < args.length; ++i) {
            Object arg;
            if (i > 0) {
                result = result + ", ";
            }
            result = (arg = args[i]) == null ? result + "null" : result + arg.toString();
        }
        return result;
    }

    public static void log(Class<?> type, String s) {
        Logging.log(ClassUtility.simpleClassName(type) + ": " + s);
    }

    public static void log(Object object, String s) {
        Logging.log(ClassUtility.simpleClassName(object.getClass()) + ": " + s);
    }
}

