/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.graphic;

import fitlibrary.differences.LocalFile;
import fitlibrary.parser.HtmlStructureParser;
import fitlibrary.parser.Parser;
import fitlibrary.parser.graphic.GraphicInterface;
import fitlibrary.parser.lookup.ParserFactory;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;

public class GraphicParser
extends HtmlStructureParser {
    public GraphicParser(Typed typed) {
        super(typed);
    }

    public static boolean applicableType(Class<?> type) {
        return GraphicInterface.class.isAssignableFrom(type);
    }

    protected Object parse(String imageLink) {
        Object[] args = new Object[]{this.getImageFileName(imageLink)};
        Class[] argTypes = new Class[]{LocalFile.class};
        return this.callReflectively("parseGraphic", args, argTypes, null);
    }

    @Override
    public String show(Object object) {
        if (object == null) {
            return "null";
        }
        LocalFile localFile = (LocalFile)this.callReflectively("toGraphic", new Object[0], new Class[0], object);
        String htmlImageLink = localFile.htmlImageLink();
        return htmlImageLink;
    }

    public LocalFile getImageFileName(String html) {
        String match = "src=\"";
        int srcPos = html.indexOf(match);
        if (srcPos < 0) {
            throw new RuntimeException("Not a valid graphic link: '" + html + "'");
        }
        int start = srcPos + match.length();
        int end = html.indexOf("\"", start);
        String fileName = html.substring(start, end);
        return Traverse.getLocalFile(fileName);
    }

    @Override
    public Object parse(Cell cell, TestResults testResults) throws Exception {
        return this.parse(cell.fullText());
    }

    public static ParserFactory parserFactory() {
        return new ParserFactory(){

            @Override
            public Parser parser(Evaluator evaluator, Typed typed) {
                return new GraphicParser(typed);
            }
        };
    }

    @Override
    public Evaluator traverse(TypedObject typedObject) {
        throw new RuntimeException("No Traverse available");
    }
}

