/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.lookup;

import fitlibrary.log.FitLibraryLogger;
import fitlibrary.parser.DelegateParser;
import fitlibrary.parser.DelegatingParser;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.ParserFactory;
import fitlibrary.parser.self.SelfConstructorParser;
import fitlibrary.parser.self.SelfParser;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class ParseDelegation {
    static Logger logger = FitLibraryLogger.getLogger(ParseDelegation.class);
    private static Map<Class<?>, DelegateParser> PARSE_DELEGATES = new ConcurrentHashMap();
    private static Map<Class<?>, DelegateParser> SUPER_PARSE_DELEGATES = new ConcurrentHashMap();

    public static void registerParseDelegate(Class<?> type, Class<?> parseDelegate) {
        SelfParser delegate = SelfParser.findSelfParser(parseDelegate);
        if (delegate == null) {
            throw new RuntimeException("Parse delegate class " + parseDelegate.getName() + " does not have a suitable static parse() method.");
        }
        PARSE_DELEGATES.put(type, delegate);
    }

    public static void registerParseDelegate(Class<?> type, Object parseDelegate) {
        try {
            DelegateObjectParser delegate = new DelegateObjectParser(type, parseDelegate);
            PARSE_DELEGATES.put(type, delegate);
        }
        catch (Exception ex) {
            throw new RuntimeException("Parse delegate object of class " + parseDelegate.getClass().getName() + " does not have a suitable parse() method.");
        }
    }

    public static void registerSuperParseDelegate(Class<?> type, Object superParseDelegate) {
        try {
            DelegateObjectSuperParser delegate = new DelegateObjectSuperParser(type, superParseDelegate);
            SUPER_PARSE_DELEGATES.put(type, delegate);
        }
        catch (Exception ex) {
            throw new RuntimeException("Super parse delegate object of class " + superParseDelegate.getClass().getName() + " does not have a suitable parse() method.");
        }
    }

    public static void clearDelegatesForNextStorytest() {
        PARSE_DELEGATES.clear();
        SUPER_PARSE_DELEGATES.clear();
    }

    public static boolean hasParseMethod(Class<?> type) {
        return SelfParser.findParseMethod(type) != null;
    }

    public static DelegateParser getDelegate(Class<?> type) {
        DelegateParser delegateParser = PARSE_DELEGATES.get(type);
        if (delegateParser != null) {
            return delegateParser;
        }
        for (Class<?> keyType : SUPER_PARSE_DELEGATES.keySet()) {
            if (!keyType.isAssignableFrom(type)) continue;
            return SUPER_PARSE_DELEGATES.get(keyType);
        }
        return null;
    }

    public static ParserFactory selfParseFactory(Typed typed) {
        final DelegateParser classParser = ParseDelegation.findSelfParser(typed);
        if (classParser != null) {
            return new ParserFactory(){

                @Override
                public Parser parser(Evaluator evaluator, Typed typed2) {
                    return new DelegatingParser(classParser, evaluator, typed2);
                }
            };
        }
        return null;
    }

    private static DelegateParser findSelfParser(Typed typed) {
        DelegateParser classParser = SelfParser.findSelfParser(typed.asClass());
        if (classParser == null) {
            classParser = SelfConstructorParser.findSelfConstructorParser(typed.asClass());
        }
        return classParser;
    }

    static class DelegateObjectParser
    extends AbstractDelegateObjectParser {
        public DelegateObjectParser(Class<?> type, Object delegate) throws SecurityException, NoSuchMethodException {
            super(type, delegate);
            this.parseMethod = delegate.getClass().getMethod("parse", String.class);
        }

        @Override
        public Object parse(String s, Typed typed) throws Exception {
            logger.trace((Object)("Parsing with " + this.parseMethod.getName() + "() of " + this.delegate));
            return this.parseMethod.invoke(this.delegate, s);
        }
    }

    static class DelegateObjectSuperParser
    extends AbstractDelegateObjectParser {
        public DelegateObjectSuperParser(Class<?> type, Object delegate) throws SecurityException, NoSuchMethodException {
            super(type, delegate);
            this.parseMethod = delegate.getClass().getMethod("parse", String.class, Class.class);
        }

        @Override
        public Object parse(String s, Typed typed) throws Exception {
            logger.trace((Object)("Parsing with " + this.parseMethod.getName() + "() of " + this.delegate));
            return this.parseMethod.invoke(this.delegate, s, typed.asClass());
        }
    }

    static abstract class AbstractDelegateObjectParser
    extends DelegateParser
    implements Cloneable {
        protected Object delegate;
        protected Method parseMethod;
        protected Method matchesMethod;
        protected Method showMethod;

        public AbstractDelegateObjectParser(Class<?> type, Object delegate) {
            super(null);
            this.delegate = delegate;
            try {
                this.matchesMethod = delegate.getClass().getMethod("matches", type, type);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.showMethod = delegate.getClass().getMethod("show", type);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public boolean matches(Object a, Object b) {
            if (this.matchesMethod != null) {
                try {
                    return (Boolean)this.matchesMethod.invoke(this.delegate, a, b);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return super.matches(a, b);
        }

        @Override
        public String show(Object object) {
            if (this.showMethod != null) {
                try {
                    return (String)this.showMethod.invoke(this.delegate, object);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return super.show(object);
        }
    }
}

