/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.self;

import fitlibrary.log.FitLibraryLogger;
import fitlibrary.parser.DelegateParser;
import fitlibrary.typed.Typed;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.log4j.Logger;

public class SelfConstructorParser
extends DelegateParser
implements Cloneable {
    static Logger logger = FitLibraryLogger.getLogger(SelfConstructorParser.class);
    private Constructor<?> constructor;

    public static SelfConstructorParser findSelfConstructorParser(Class<?> type) {
        Constructor<?> constructor = SelfConstructorParser.findConstructor(type);
        if (constructor == null) {
            return null;
        }
        return new SelfConstructorParser(constructor);
    }

    public SelfConstructorParser(Constructor<?> parseMethod) {
        this.constructor = parseMethod;
    }

    public static Constructor<?> findConstructor(Class<?> type) {
        Constructor<?>[] declaredConstructors;
        if (Modifier.isAbstract(type.getModifiers())) {
            return null;
        }
        for (Constructor<?> constructor : declaredConstructors = type.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 1 || constructor.getParameterTypes()[0] != String.class) continue;
            return constructor;
        }
        return null;
    }

    @Override
    public Object parse(String s, Typed typed) throws Exception {
        logger.trace((Object)("Parsing with " + this.constructor.getName() + "()"));
        this.constructor.setAccessible(true);
        return this.constructor.newInstance(s);
    }
}

